/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class ComboBoxWithWidePopup
extends JComboBox {
    private boolean myLayingOut = false;
    private int myMinLength = 20;

    public ComboBoxWithWidePopup(ComboBoxModel aModel) {
        super(aModel);
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    public ComboBoxWithWidePopup(Object[] items) {
        super(items);
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    public ComboBoxWithWidePopup(Vector<?> items) {
        super(items);
        if (SystemInfo.isMac && UIUtil.isUnderAquaLookAndFeel()) {
            this.setMaximumRowCount(25);
        }
    }

    public ComboBoxWithWidePopup() {
    }

    public void setRenderer(ListCellRenderer renderer) {
        super.setRenderer(new AdjustingListCellRenderer(this, renderer));
    }

    public void setMinLength(int minLength) {
        this.myMinLength = minLength;
    }

    protected int getMinLength() {
        return this.myMinLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLayout() {
        try {
            this.myLayingOut = true;
            super.doLayout();
        }
        finally {
            this.myLayingOut = false;
        }
    }

    @Override
    public Dimension getSize() {
        Dimension size = super.getSize();
        if (!this.myLayingOut) {
            size.width = Math.max(size.width, this.getOriginalPreferredSize().width);
        }
        return size;
    }

    private Dimension _getSuperSize() {
        return super.getSize();
    }

    protected Dimension getOriginalPreferredSize() {
        return this.getPreferredSize();
    }

    private class AdjustingListCellRenderer
    implements ListCellRenderer {
        private final ListCellRenderer myOldRenderer;
        private final ComboBoxWithWidePopup myComboBox;

        public AdjustingListCellRenderer(ComboBoxWithWidePopup comboBox, ListCellRenderer oldRenderer) {
            this.myComboBox = comboBox;
            this.myOldRenderer = oldRenderer;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object _value = value;
            if (index == -1 && _value instanceof String && !this.myComboBox.isValid()) {
                int minLength = ComboBoxWithWidePopup.this.getMinLength();
                Dimension size = this.myComboBox._getSuperSize();
                String stringValue = (String)_value;
                if (size.width == 0 && stringValue.length() > minLength) {
                    _value = stringValue.substring(0, minLength);
                }
            }
            return this.myOldRenderer.getListCellRendererComponent(list, _value, index, isSelected, cellHasFocus);
        }
    }
}

