/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.InternalFileType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public class ProjectCoreUtil {
    public static final String DIRECTORY_BASED_PROJECT_DIR = ".idea";

    public static boolean isProjectOrWorkspaceFile(VirtualFile file) {
        return ProjectCoreUtil.isProjectOrWorkspaceFile(file, file.getFileType());
    }

    public static boolean isProjectOrWorkspaceFile(VirtualFile file, @Nullable FileType fileType) {
        VirtualFile parent;
        if (fileType instanceof InternalFileType) {
            return true;
        }
        VirtualFile virtualFile = parent = file.isDirectory() ? file : file.getParent();
        while (parent != null) {
            if (Comparing.equal((CharSequence)parent.getNameSequence(), (CharSequence)DIRECTORY_BASED_PROJECT_DIR, (boolean)SystemInfoRt.isFileSystemCaseSensitive)) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }
}

