/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleAdapter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ModuleNameTracker
extends ModuleAdapter {
    private final Map<Module, String> myModulesNames = new HashMap<Module, String>();
    private final Project myProject;

    public ModuleNameTracker(Project project) {
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)new Disposable(){

            public void dispose() {
                ModuleNameTracker.this.myModulesNames.clear();
            }
        });
    }

    @Override
    public void moduleAdded(Project project, Module module) {
        if (this.myProject == project) {
            this.myModulesNames.put(module, module.getName());
        }
    }

    @Override
    public void moduleRemoved(Project project, Module module) {
        if (this.myProject == project) {
            this.myModulesNames.remove(module);
        }
    }

    @Override
    public void modulesRenamed(Project project, List<Module> modules) {
        if (this.myProject != project) {
            return;
        }
        HashMap<String, String> old2newNames = new HashMap<String, String>(modules.size());
        for (Module module : modules) {
            String newName = module.getName();
            String oldName = this.myModulesNames.put(module, newName);
            old2newNames.put(oldName, newName);
        }
        this.modulesRenamed(project, old2newNames);
    }

    protected abstract void modulesRenamed(Project var1, Map<String, String> var2);
}

