/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.AbstractTaskQueue;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class ProgressManagerQueue
extends AbstractTaskQueue<Runnable> {
    private final ProgressManager myProgressManager;
    private final Task.Backgroundable myQueuePollTask;
    private volatile boolean myIsStarted;

    public ProgressManagerQueue(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/progress/ProgressManagerQueue", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/openapi/progress/ProgressManagerQueue", "<init>"));
        }
        this.myProgressManager = ProgressManager.getInstance();
        this.myQueuePollTask = new Task.Backgroundable(project, title){

            @Override
            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/progress/ProgressManagerQueue$1", "run"));
                }
                ProgressManagerQueue.this.myQueueWorker.run();
            }
        };
    }

    public void start() {
        this.myIsStarted = true;
        this.runMe();
    }

    @Override
    protected void runMe() {
        if (!this.myIsStarted) {
            return;
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            if (this.myQueuePollTask.myProject.isDisposed() || this.isEmpty()) {
                return;
            }
            this.myProgressManager.run(this.myQueuePollTask);
        } else {
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (((ProgressManagerQueue)ProgressManagerQueue.this).myQueuePollTask.myProject.isDisposed() || ProgressManagerQueue.this.isEmpty()) {
                        return;
                    }
                    ProgressManagerQueue.this.myProgressManager.run(ProgressManagerQueue.this.myQueuePollTask);
                }
            });
        }
    }

    @Override
    protected void runStuff(Runnable stuff) {
        try {
            stuff.run();
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }
}

