/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes;

import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeListener;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.MockLanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MockFileTypeManager
extends FileTypeManager {
    MockFileTypeManager() {
    }

    @Override
    public void registerFileType(@NotNull FileType type, @NotNull List<FileNameMatcher> defaultAssociations) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/MockFileTypeManager", "registerFileType"));
        }
        if (defaultAssociations == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultAssociations", "com/intellij/openapi/fileTypes/MockFileTypeManager", "registerFileType"));
        }
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public FileType getFileTypeByFileName(@NotNull @NonNls String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getFileTypeByFileName"));
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getFileTypeByFileName"));
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public FileType getFileTypeByFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getFileTypeByFile"));
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getFileTypeByFile"));
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public FileType getFileTypeByExtension(@NonNls @NotNull String extension) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getFileTypeByExtension"));
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getFileTypeByExtension"));
        }
        return languageFileType;
    }

    @Override
    @NotNull
    public FileType[] getRegisteredFileTypes() {
        FileType[] fileTypeArray = new FileType[]{MockLanguageFileType.INSTANCE};
        if (fileTypeArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getRegisteredFileTypes"));
        }
        return fileTypeArray;
    }

    @Override
    public boolean isFileIgnored(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/fileTypes/MockFileTypeManager", "isFileIgnored"));
        }
        return false;
    }

    @Override
    public boolean isFileIgnored(@NonNls @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/MockFileTypeManager", "isFileIgnored"));
        }
        return false;
    }

    @Override
    @NotNull
    public String[] getAssociatedExtensions(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getAssociatedExtensions"));
        }
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getAssociatedExtensions"));
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    @NotNull
    public List<FileNameMatcher> getAssociations(@NotNull FileType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getAssociations"));
        }
        List<FileNameMatcher> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getAssociations"));
        }
        return list;
    }

    @Override
    public void addFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileTypes/MockFileTypeManager", "addFileTypeListener"));
        }
    }

    @Override
    public void removeFileTypeListener(@NotNull FileTypeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileTypes/MockFileTypeManager", "removeFileTypeListener"));
        }
    }

    @Override
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getKnownFileTypeOrAssociate"));
        }
        return file.getFileType();
    }

    @Override
    public FileType getKnownFileTypeOrAssociate(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getKnownFileTypeOrAssociate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getKnownFileTypeOrAssociate"));
        }
        return this.getKnownFileTypeOrAssociate(file);
    }

    @Override
    @NotNull
    public String getIgnoredFilesList() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getIgnoredFilesList"));
        }
        return "";
    }

    @Override
    public void setIgnoredFilesList(@NotNull String list) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/fileTypes/MockFileTypeManager", "setIgnoredFilesList"));
        }
    }

    @Override
    public void associate(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/MockFileTypeManager", "associate"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/MockFileTypeManager", "associate"));
        }
    }

    @Override
    public void removeAssociation(@NotNull FileType type, @NotNull FileNameMatcher matcher) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/MockFileTypeManager", "removeAssociation"));
        }
        if (matcher == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matcher", "com/intellij/openapi/fileTypes/MockFileTypeManager", "removeAssociation"));
        }
    }

    @Override
    @NotNull
    public FileType getStdFileType(@NotNull @NonNls String fileTypeName) {
        if (fileTypeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeName", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getStdFileType"));
        }
        LanguageFileType languageFileType = MockLanguageFileType.INSTANCE;
        if (languageFileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "getStdFileType"));
        }
        return languageFileType;
    }

    @Override
    public boolean isFileOfType(@NotNull VirtualFile file, @NotNull FileType type) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/MockFileTypeManager", "isFileOfType"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/fileTypes/MockFileTypeManager", "isFileOfType"));
        }
        return false;
    }

    @Override
    @NotNull
    public FileType detectFileTypeFromContent(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileTypes/MockFileTypeManager", "detectFileTypeFromContent"));
        }
        FileType fileType = UnknownFileType.INSTANCE;
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileTypes/MockFileTypeManager", "detectFileTypeFromContent"));
        }
        return fileType;
    }

    @Override
    @Nullable
    public FileType findFileTypeByName(String fileTypeName) {
        return null;
    }
}

