/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import com.intellij.openapi.externalSystem.model.DefaultExternalPlugin;
import com.intellij.openapi.externalSystem.model.DefaultExternalSourceSet;
import com.intellij.openapi.externalSystem.model.DefaultExternalTask;
import com.intellij.openapi.externalSystem.model.ExternalPlugin;
import com.intellij.openapi.externalSystem.model.ExternalProject;
import com.intellij.openapi.externalSystem.model.ExternalSourceSet;
import com.intellij.openapi.externalSystem.model.ExternalTask;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultExternalProject
implements ExternalProject {
    private static final long serialVersionUID = 1L;
    @NotNull
    private String myName;
    @NotNull
    private String myQName;
    @Nullable
    private String myDescription;
    @NotNull
    private String myGroup;
    @NotNull
    private String myVersion;
    @NotNull
    private Map<String, ExternalProject> myChildProjects;
    @NotNull
    private File myProjectDir;
    @NotNull
    private File myBuildDir;
    @Nullable
    private File myBuildFile;
    @NotNull
    private Map<String, ExternalTask> myTasks;
    @NotNull
    private Map<String, ?> myProperties;
    @NotNull
    private Map<String, ExternalSourceSet> mySourceSets;
    @NotNull
    private String myExternalSystemId;
    @NotNull
    private Map<String, ExternalPlugin> myPlugins;

    public DefaultExternalProject() {
        this.myChildProjects = new HashMap<String, ExternalProject>();
        this.myTasks = new HashMap<String, ExternalTask>();
        this.myProperties = new HashMap();
        this.mySourceSets = new HashMap<String, ExternalSourceSet>();
        this.myPlugins = new HashMap<String, ExternalPlugin>();
    }

    public DefaultExternalProject(@NotNull ExternalProject externalProject) {
        if (externalProject == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProject", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "<init>"));
        }
        this();
        this.myName = externalProject.getName();
        this.myQName = externalProject.getQName();
        this.myVersion = externalProject.getVersion();
        this.myGroup = externalProject.getGroup();
        this.myDescription = externalProject.getDescription();
        this.myProjectDir = externalProject.getProjectDir();
        this.myBuildDir = externalProject.getBuildDir();
        this.myBuildFile = externalProject.getBuildFile();
        this.myExternalSystemId = externalProject.getExternalSystemId();
        for (Map.Entry<String, ExternalProject> entry : externalProject.getChildProjects().entrySet()) {
            this.myChildProjects.put(entry.getKey(), new DefaultExternalProject(entry.getValue()));
        }
        for (Map.Entry<String, Serializable> entry : externalProject.getTasks().entrySet()) {
            this.myTasks.put(entry.getKey(), new DefaultExternalTask((ExternalTask)entry.getValue()));
        }
        for (Map.Entry<String, Serializable> entry : externalProject.getSourceSets().entrySet()) {
            this.mySourceSets.put(entry.getKey(), new DefaultExternalSourceSet((ExternalSourceSet)entry.getValue()));
        }
        for (Map.Entry<String, Serializable> entry : externalProject.getPlugins().entrySet()) {
            this.myPlugins.put(entry.getKey(), new DefaultExternalPlugin((ExternalPlugin)entry.getValue()));
        }
    }

    @Override
    @NotNull
    public String getExternalSystemId() {
        String string = this.myExternalSystemId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getExternalSystemId"));
        }
        return string;
    }

    public void setExternalSystemId(@NotNull String externalSystemId) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setExternalSystemId"));
        }
        this.myExternalSystemId = externalSystemId;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getName"));
        }
        return string;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setName"));
        }
        this.myName = name;
    }

    @Override
    @NotNull
    public String getQName() {
        String string = this.myQName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getQName"));
        }
        return string;
    }

    public void setQName(@NotNull String QName) {
        if (QName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "QName", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setQName"));
        }
        this.myQName = QName;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@Nullable String description) {
        this.myDescription = description;
    }

    @Override
    @NotNull
    public String getGroup() {
        String string = this.myGroup;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getGroup"));
        }
        return string;
    }

    public void setGroup(@NotNull String group) {
        if (group == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "group", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setGroup"));
        }
        this.myGroup = group;
    }

    @Override
    @NotNull
    public String getVersion() {
        String string = this.myVersion;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getVersion"));
        }
        return string;
    }

    public void setVersion(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setVersion"));
        }
        this.myVersion = version;
    }

    @Override
    @NotNull
    public Map<String, ExternalProject> getChildProjects() {
        Map<String, ExternalProject> map = this.myChildProjects;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getChildProjects"));
        }
        return map;
    }

    public void setChildProjects(@NotNull Map<String, ExternalProject> childProjects) {
        if (childProjects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "childProjects", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setChildProjects"));
        }
        this.myChildProjects = childProjects;
    }

    @Override
    @NotNull
    public File getProjectDir() {
        File file = this.myProjectDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getProjectDir"));
        }
        return file;
    }

    public void setProjectDir(@NotNull File projectDir) {
        if (projectDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectDir", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setProjectDir"));
        }
        this.myProjectDir = projectDir;
    }

    @Override
    @NotNull
    public File getBuildDir() {
        File file = this.myBuildDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getBuildDir"));
        }
        return file;
    }

    public void setBuildDir(@NotNull File buildDir) {
        if (buildDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildDir", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setBuildDir"));
        }
        this.myBuildDir = buildDir;
    }

    @Override
    @Nullable
    public File getBuildFile() {
        return this.myBuildFile;
    }

    public void setBuildFile(@Nullable File buildFile) {
        this.myBuildFile = buildFile;
    }

    @Override
    @NotNull
    public Map<String, ExternalTask> getTasks() {
        Map<String, ExternalTask> map = this.myTasks;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getTasks"));
        }
        return map;
    }

    public void setTasks(@NotNull Map<String, ExternalTask> tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setTasks"));
        }
        this.myTasks = tasks;
    }

    @Override
    @NotNull
    public Map<String, ExternalPlugin> getPlugins() {
        Map<String, ExternalPlugin> map = this.myPlugins;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getPlugins"));
        }
        return map;
    }

    public void setPlugins(@NotNull Map<String, ExternalPlugin> plugins) {
        if (plugins == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "plugins", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setPlugins"));
        }
        this.myPlugins = plugins;
    }

    @Override
    @NotNull
    public Map<String, ?> getProperties() {
        Map<String, ?> map = this.myProperties;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getProperties"));
        }
        return map;
    }

    public void setProperties(@NotNull Map<String, ?> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setProperties"));
        }
        this.myProperties = properties;
    }

    @Override
    @Nullable
    public Object getProperty(String name) {
        return this.myProperties.get(name);
    }

    @Override
    @NotNull
    public Map<String, ExternalSourceSet> getSourceSets() {
        Map<String, ExternalSourceSet> map = this.mySourceSets;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "getSourceSets"));
        }
        return map;
    }

    public void setSourceSets(@NotNull Map<String, ExternalSourceSet> sourceSets) {
        if (sourceSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSets", "com/intellij/openapi/externalSystem/model/DefaultExternalProject", "setSourceSets"));
        }
        this.mySourceSets = sourceSets;
    }
}

