/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff;

import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffTool;
import com.intellij.openapi.diff.DiffToolbar;
import com.intellij.openapi.diff.DiffViewerType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DiffRequest {
    @NonNls
    private static final String COMMON_DIFF_GROUP_KEY = "DiffWindow";
    private String myGroupKey = "DiffWindow";
    @Nullable
    private final Project myProject;
    private ToolbarAddons myToolbarAddons = ToolbarAddons.NOTHING;
    private Factory<JComponent> myBottomComponentFactory = null;
    private final HashSet myHints = new HashSet();
    private final Map<String, Object> myGenericData;
    private Runnable myOnOkRunnable;
    private final List<Pair<String, DiffRequest>> myAdditional;

    protected DiffRequest(@Nullable Project project) {
        this.myProject = project;
        this.myGenericData = new HashMap<String, Object>(2);
        this.myAdditional = new ArrayList<Pair<String, DiffRequest>>(0);
    }

    public void setToolbarAddons(@NotNull ToolbarAddons toolbarAddons) {
        if (toolbarAddons == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolbarAddons", "com/intellij/openapi/diff/DiffRequest", "setToolbarAddons"));
        }
        this.myToolbarAddons = toolbarAddons;
        if (this.haveMultipleLayers()) {
            for (Pair<String, DiffRequest> pair : this.myAdditional) {
                ((DiffRequest)pair.getSecond()).setToolbarAddons(toolbarAddons);
            }
        }
    }

    public String getGroupKey() {
        return this.myGroupKey;
    }

    public void setGroupKey(@NonNls String groupKey) {
        this.myGroupKey = groupKey;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    public boolean isSafeToCallFromUpdate() {
        return true;
    }

    @NotNull
    public abstract DiffContent[] getContents();

    public DiffViewerType getType() {
        if (this.haveMultipleLayers()) {
            return DiffViewerType.multiLayer;
        }
        if (this.getContentTitles().length == 3) {
            return DiffViewerType.merge;
        }
        return DiffViewerType.contents;
    }

    public boolean haveMultipleLayers() {
        return !this.getOtherLayers().isEmpty();
    }

    public void addOtherLayer(String name, DiffRequest request) {
        this.myAdditional.add((Pair<String, DiffRequest>)Pair.create((Object)name, (Object)request));
    }

    public List<Pair<String, DiffRequest>> getOtherLayers() {
        return this.myAdditional;
    }

    public abstract String[] getContentTitles();

    public abstract String getWindowTitle();

    public void setWindowTitle(String value) {
    }

    public void customizeToolbar(DiffToolbar toolbar) {
        this.myToolbarAddons.customize(toolbar);
    }

    public Collection getHints() {
        return Collections.unmodifiableCollection(this.myHints);
    }

    public void passForDataContext(DataKey key, Object value) {
        this.myGenericData.put(key.getName(), value);
        if (this.haveMultipleLayers()) {
            for (Pair<String, DiffRequest> pair : this.myAdditional) {
                ((DiffRequest)pair.getSecond()).passForDataContext(key, value);
            }
        }
    }

    public Map<String, Object> getGenericData() {
        return this.myGenericData;
    }

    public void addHint(Object hint) {
        this.myHints.add(hint);
        if (this.haveMultipleLayers() && !DiffTool.HINT_ALLOW_NO_DIFFERENCES.equals(hint)) {
            for (Pair<String, DiffRequest> pair : this.myAdditional) {
                ((DiffRequest)pair.getSecond()).addHint(hint);
            }
        }
    }

    public void removeHint(Object hint) {
        this.myHints.remove(hint);
        if (this.haveMultipleLayers()) {
            for (Pair<String, DiffRequest> pair : this.myAdditional) {
                ((DiffRequest)pair.getSecond()).removeHint(hint);
            }
        }
    }

    @Nullable
    public JComponent getBottomComponent() {
        return this.myBottomComponentFactory == null ? null : (JComponent)this.myBottomComponentFactory.create();
    }

    public void setBottomComponentFactory(Factory<JComponent> factory) {
        this.myBottomComponentFactory = factory;
    }

    public Runnable getOnOkRunnable() {
        return this.myOnOkRunnable;
    }

    public void setOnOkRunnable(Runnable onOkRunnable) {
        this.myOnOkRunnable = onOkRunnable;
    }

    public static interface ToolbarAddons {
        public static final ToolbarAddons NOTHING = new ToolbarAddons(){

            @Override
            public void customize(DiffToolbar toolbar) {
            }
        };
        public static final ToolbarAddons IDE_FRAME = new ToolbarAddons(){

            @Override
            public void customize(DiffToolbar toolbar) {
                toolbar.removeActionById("$Copy");
                toolbar.removeActionById("Find");
            }
        };

        public void customize(DiffToolbar var1);
    }
}

