/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.xmlb.annotations.Attribute;
import java.util.ArrayList;
import java.util.List;

public class ServiceBean
implements PluginAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.components.ServiceBean");
    @Attribute(value="serviceInterface")
    public String serviceInterface;
    private PluginDescriptor myPluginDescriptor;

    public static <T> List<T> loadServicesFromBeans(ExtensionPointName<ServiceBean> epName, Class<T> componentClass) {
        ServiceBean[] exportableBeans;
        ArrayList components = new ArrayList();
        for (ServiceBean exportableBean : exportableBeans = (ServiceBean[])Extensions.getExtensions(epName)) {
            String serviceClass = exportableBean.serviceInterface;
            if (serviceClass == null) {
                LOG.error("Service interface not specified in " + epName);
                continue;
            }
            try {
                Class<?> aClass = Class.forName(serviceClass, true, exportableBean.getPluginDescriptor().getPluginClassLoader());
                Object service = ServiceManager.getService(aClass);
                if (service == null) {
                    LOG.error("Can't find service: " + serviceClass);
                    continue;
                }
                if (!componentClass.isInstance(service)) {
                    LOG.error("Service " + serviceClass + " is registered in " + epName.getName() + " EP, but doesn't implement " + componentClass.getName());
                    continue;
                }
                components.add(service);
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        return components;
    }

    public void setPluginDescriptor(PluginDescriptor pluginDescriptor) {
        this.myPluginDescriptor = pluginDescriptor;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.myPluginDescriptor;
    }
}

