/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEventVisitor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataContextWrapper;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.PlaceProvider;
import java.awt.event.InputEvent;
import java.util.HashMap;
import java.util.Map;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnActionEvent
implements PlaceProvider<String> {
    private final InputEvent myInputEvent;
    @NotNull
    private final ActionManager myActionManager;
    @NotNull
    private final DataContext myDataContext;
    @NotNull
    private final String myPlace;
    @NotNull
    private final Presentation myPresentation;
    @JdkConstants.InputEventMask
    private final int myModifiers;
    private boolean myWorksInInjected;
    @NonNls
    private static final String ourInjectedPrefix = "$injected$.";
    private static final Map<String, String> ourInjectedIds = new HashMap<String, String>();

    public AnActionEvent(InputEvent inputEvent, @NotNull DataContext dataContext, @NotNull @NonNls String place, @NotNull Presentation presentation, @NotNull ActionManager actionManager, @JdkConstants.InputEventMask int modifiers) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/actionSystem/AnActionEvent", "<init>"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/AnActionEvent", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/actionSystem/AnActionEvent", "<init>"));
        }
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/openapi/actionSystem/AnActionEvent", "<init>"));
        }
        this.myInputEvent = inputEvent;
        this.myActionManager = actionManager;
        this.myDataContext = dataContext;
        this.myPlace = place;
        this.myPresentation = presentation;
        this.myModifiers = modifiers;
    }

    @NotNull
    public static AnActionEvent createFromInputEvent(@NotNull AnAction action, InputEvent event, @NotNull String place) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/AnActionEvent", "createFromInputEvent"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/actionSystem/AnActionEvent", "createFromInputEvent"));
        }
        DataContext context = event == null ? DataManager.getInstance().getDataContext() : DataManager.getInstance().getDataContext(event.getComponent());
        int modifiers = event == null ? 0 : event.getModifiers();
        AnActionEvent anActionEvent = new AnActionEvent(event, context, place, action.getTemplatePresentation(), ActionManager.getInstance(), modifiers);
        anActionEvent.setInjectedContext(action.isInInjectedContext());
        AnActionEvent anActionEvent2 = anActionEvent;
        if (anActionEvent2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnActionEvent", "createFromInputEvent"));
        }
        return anActionEvent2;
    }

    public InputEvent getInputEvent() {
        return this.myInputEvent;
    }

    @Nullable
    public Project getProject() {
        return this.getData(CommonDataKeys.PROJECT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNls
    public static String injectedId(String dataId) {
        Map<String, String> map = ourInjectedIds;
        synchronized (map) {
            String injected = ourInjectedIds.get(dataId);
            if (injected == null) {
                injected = ourInjectedPrefix + dataId;
                ourInjectedIds.put(dataId, injected);
            }
            return injected;
        }
    }

    @NonNls
    public static String uninjectedId(@NotNull String dataId) {
        if (dataId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/openapi/actionSystem/AnActionEvent", "uninjectedId"));
        }
        return StringUtil.trimStart((String)dataId, (String)ourInjectedPrefix);
    }

    public static DataContext getInjectedDataContext(DataContext context) {
        return new DataContextWrapper(context){

            @Override
            @Nullable
            public Object getData(@NonNls String dataId) {
                Object injected = super.getData(AnActionEvent.injectedId(dataId));
                if (injected != null) {
                    return injected;
                }
                return super.getData(dataId);
            }
        };
    }

    @NotNull
    public DataContext getDataContext() {
        DataContext dataContext = this.myWorksInInjected ? AnActionEvent.getInjectedDataContext(this.myDataContext) : this.myDataContext;
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnActionEvent", "getDataContext"));
        }
        return dataContext;
    }

    @Nullable
    public <T> T getData(@NotNull DataKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/actionSystem/AnActionEvent", "getData"));
        }
        return key.getData(this.getDataContext());
    }

    @NotNull
    public <T> T getRequiredData(@NotNull DataKey<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/actionSystem/AnActionEvent", "getRequiredData"));
        }
        T data = this.getData(key);
        assert (data != null);
        T t = data;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnActionEvent", "getRequiredData"));
        }
        return t;
    }

    @Override
    @NotNull
    public String getPlace() {
        String string = this.myPlace;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnActionEvent", "getPlace"));
        }
        return string;
    }

    @NotNull
    public Presentation getPresentation() {
        Presentation presentation = this.myPresentation;
        if (presentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnActionEvent", "getPresentation"));
        }
        return presentation;
    }

    @JdkConstants.InputEventMask
    public int getModifiers() {
        return this.myModifiers;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/actionSystem/AnActionEvent", "getActionManager"));
        }
        return actionManager;
    }

    public void setInjectedContext(boolean worksInInjected) {
        this.myWorksInInjected = worksInInjected;
    }

    public boolean isInInjectedContext() {
        return this.myWorksInInjected;
    }

    public void accept(@NotNull AnActionEventVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/openapi/actionSystem/AnActionEvent", "accept"));
        }
        visitor.visitEvent(this);
    }
}

