/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notification;

import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Notification {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.notification.Notification");
    private final String myGroupId;
    private final String myContent;
    private final NotificationType myType;
    private final NotificationListener myListener;
    private final String myTitle;
    private boolean myExpired;
    private Runnable myWhenExpired;
    private Boolean myImportant;
    private WeakReference<Balloon> myBalloonRef;

    public Notification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/notification/Notification", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/Notification", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/Notification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/Notification", "<init>"));
        }
        this(groupDisplayId, title, content, type, null);
    }

    public Notification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content, @NotNull NotificationType type, @Nullable NotificationListener listener) {
        if (groupDisplayId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupDisplayId", "com/intellij/notification/Notification", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/notification/Notification", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/notification/Notification", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/notification/Notification", "<init>"));
        }
        this.myGroupId = groupDisplayId;
        this.myTitle = title;
        this.myContent = content;
        this.myType = type;
        this.myListener = listener;
        LOG.assertTrue(!StringUtil.isEmptyOrSpaces((String)this.myContent), (Object)("Notification should have content, groupId: " + this.myGroupId));
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @NotNull
    public String getGroupId() {
        String string = this.myGroupId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getGroupId"));
        }
        return string;
    }

    @NotNull
    public String getTitle() {
        String string = this.myTitle;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getTitle"));
        }
        return string;
    }

    @NotNull
    public String getContent() {
        String string = this.myContent;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getContent"));
        }
        return string;
    }

    @Nullable
    public NotificationListener getListener() {
        return this.myListener;
    }

    @NotNull
    public NotificationType getType() {
        NotificationType notificationType = this.myType;
        if (notificationType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/notification/Notification", "getType"));
        }
        return notificationType;
    }

    public boolean isExpired() {
        return this.myExpired;
    }

    public void expire() {
        NotificationsManager.getNotificationsManager().expire(this);
        this.hideBalloon();
        this.myExpired = true;
        Runnable whenExpired = this.myWhenExpired;
        if (whenExpired != null) {
            whenExpired.run();
        }
    }

    public Notification whenExpired(@Nullable Runnable whenExpired) {
        this.myWhenExpired = whenExpired;
        return this;
    }

    public void hideBalloon() {
        if (this.myBalloonRef != null) {
            Balloon balloon = (Balloon)this.myBalloonRef.get();
            if (balloon != null) {
                balloon.hide();
            }
            this.myBalloonRef = null;
        }
    }

    public void setBalloon(final @NotNull Balloon balloon) {
        if (balloon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "balloon", "com/intellij/notification/Notification", "setBalloon"));
        }
        this.hideBalloon();
        this.myBalloonRef = new WeakReference<Balloon>(balloon);
        balloon.addListener(new JBPopupAdapter(){

            @Override
            public void onClosed(LightweightWindowEvent event) {
                if (SoftReference.dereference((Reference)Notification.this.myBalloonRef) == balloon) {
                    Notification.this.myBalloonRef = null;
                }
            }
        });
    }

    @Nullable
    public Balloon getBalloon() {
        return (Balloon)SoftReference.dereference(this.myBalloonRef);
    }

    public void notify(@Nullable Project project) {
        Notifications.Bus.notify(this, project);
    }

    public Notification setImportant(boolean important) {
        this.myImportant = important;
        return this;
    }

    public boolean isImportant() {
        if (this.myImportant != null) {
            return this.myImportant;
        }
        return this.getListener() != null;
    }
}

