/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ImportOptimizer;
import com.intellij.lang.LanguageExtension;
import com.intellij.psi.PsiFile;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LanguageImportStatements
extends LanguageExtension<ImportOptimizer> {
    public static final LanguageImportStatements INSTANCE = new LanguageImportStatements();

    private LanguageImportStatements() {
        super("com.intellij.lang.importOptimizer");
    }

    @NotNull
    public Set<ImportOptimizer> forFile(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/LanguageImportStatements", "forFile"));
        }
        HashSet<ImportOptimizer> optimizers = new HashSet<ImportOptimizer>();
        block0: for (PsiFile psiFile : file.getViewProvider().getAllFiles()) {
            List langOptimizers = this.allForLanguage(psiFile.getLanguage());
            for (ImportOptimizer optimizer : langOptimizers) {
                if (optimizer == null || !optimizer.supports(psiFile)) continue;
                optimizers.add(optimizer);
                continue block0;
            }
        }
        HashSet<ImportOptimizer> hashSet = optimizers;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/LanguageImportStatements", "forFile"));
        }
        return hashSet;
    }
}

