/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.treeView;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTreeStructure {
    public abstract Object getRootElement();

    public abstract Object[] getChildElements(Object var1);

    @Nullable
    public abstract Object getParentElement(Object var1);

    @NotNull
    public abstract NodeDescriptor createDescriptor(Object var1, NodeDescriptor var2);

    public abstract void commit();

    public abstract boolean hasSomethingToCommit();

    @NotNull
    public static ActionCallback asyncCommitDocuments(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/treeView/AbstractTreeStructure", "asyncCommitDocuments"));
        }
        if (project.isDisposed()) {
            ActionCallback.Done done = new ActionCallback.Done();
            if (done == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructure", "asyncCommitDocuments"));
            }
            return done;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        if (!documentManager.hasUncommitedDocuments()) {
            ActionCallback.Done done = new ActionCallback.Done();
            if (done == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructure", "asyncCommitDocuments"));
            }
            return done;
        }
        ActionCallback callback = new ActionCallback();
        documentManager.performWhenAllCommitted(callback.createSetDoneRunnable());
        ActionCallback actionCallback = callback;
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructure", "asyncCommitDocuments"));
        }
        return actionCallback;
    }

    @NotNull
    public ActionCallback asyncCommit() {
        if (this.hasSomethingToCommit()) {
            this.commit();
        }
        ActionCallback.Done done = new ActionCallback.Done();
        if (done == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/treeView/AbstractTreeStructure", "asyncCommit"));
        }
        return done;
    }

    public boolean isToBuildChildrenInBackground(Object element) {
        return false;
    }

    public boolean isValid(Object element) {
        return true;
    }

    public boolean isAlwaysLeaf(Object element) {
        return false;
    }

    public AsyncResult<Object> revalidateElement(Object element) {
        return new AsyncResult.Done<Object>(element);
    }
}

