/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard;

import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.openapi.options.ConfigurationException;
import java.io.File;
import java.util.Collections;
import java.util.Map;
import javax.swing.JComponent;

public abstract class WizardInputField<T extends JComponent> {
    private final String myId;
    private final String myDefaultValue;

    protected WizardInputField(String id, String defaultValue) {
        this.myId = id;
        this.myDefaultValue = defaultValue;
    }

    public String getId() {
        return this.myId;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public abstract String getLabel();

    public abstract T getComponent();

    public abstract String getValue();

    public Map<String, String> getValues() {
        return Collections.singletonMap(this.getId(), this.getValue());
    }

    public boolean validate() throws ConfigurationException {
        return true;
    }

    public static ProjectTemplateParameterFactory getFactoryById(String id) {
        ProjectTemplateParameterFactory[] extensions;
        for (ProjectTemplateParameterFactory extension : extensions = (ProjectTemplateParameterFactory[])ProjectTemplateParameterFactory.EP_NAME.getExtensions()) {
            if (!extension.getParameterId().equals(id)) continue;
            return extension;
        }
        return null;
    }

    public void addToSettings(SettingsStep settingsStep) {
        settingsStep.addSettingsField(this.getLabel(), (JComponent)this.getComponent());
    }

    public boolean acceptFile(File file) {
        return true;
    }

    public void setValue(String value) {
        throw new UnsupportedOperationException();
    }
}

