/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.ide.util.frameworkSupport.FrameworkRole;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurable;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.util.ArrayUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportProvider {
    public static final ExtensionPointName<FrameworkSupportProvider> EXTENSION_POINT = ExtensionPointName.create((String)"com.intellij.frameworkSupport");
    private final String myId;
    private final String myTitle;

    protected FrameworkSupportProvider(@NotNull @NonNls String id, @NotNull String title) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "<init>"));
        }
        this.myId = id;
        this.myTitle = title;
    }

    @NotNull
    public abstract FrameworkSupportConfigurable createConfigurable(@NotNull FrameworkSupportModel var1);

    @NonNls
    @Nullable
    public String getUnderlyingFrameworkId() {
        return null;
    }

    @NonNls
    public String[] getPrecedingFrameworkProviderIds() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    public String getTitle() {
        return this.myTitle;
    }

    @Nullable
    @NonNls
    public String getGroupId() {
        return null;
    }

    @NotNull
    public String[] getProjectCategories() {
        String[] stringArray;
        if (this.getGroupId() == null) {
            stringArray = ArrayUtil.EMPTY_STRING_ARRAY;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getGroupId();
        }
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "getProjectCategories"));
        }
        return stringArray;
    }

    public FrameworkRole[] getRoles() {
        FrameworkRole[] frameworkRoleArray;
        if (this.getGroupId() == null) {
            frameworkRoleArray = FrameworkRole.UNKNOWN;
        } else {
            FrameworkRole[] frameworkRoleArray2 = new FrameworkRole[1];
            frameworkRoleArray = frameworkRoleArray2;
            frameworkRoleArray2[0] = new FrameworkRole(this.getGroupId());
        }
        return frameworkRoleArray;
    }

    @Nullable
    public Icon getIcon() {
        return null;
    }

    public abstract boolean isEnabledForModuleType(@NotNull ModuleType var1);

    public boolean isEnabledForModuleBuilder(@NotNull ModuleBuilder builder) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "isEnabledForModuleBuilder"));
        }
        return this.isEnabledForModuleType(builder.getModuleType());
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "isSupportAlreadyAdded"));
        }
        return false;
    }

    public boolean isSupportAlreadyAdded(@NotNull Module module, @NotNull FacetsProvider facetsProvider) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "isSupportAlreadyAdded"));
        }
        if (facetsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetsProvider", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "isSupportAlreadyAdded"));
        }
        return this.isSupportAlreadyAdded(module);
    }

    @NotNull
    @NonNls
    public final String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/frameworkSupport/FrameworkSupportProvider", "getId"));
        }
        return string;
    }
}

