/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.util.ExecUtil;
import com.intellij.ide.browsers.BrowserLauncher;
import com.intellij.ide.browsers.BrowserLauncherAppless;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowserUtil {
    private static final Pattern ourExternalPrefix = Pattern.compile("^[\\w\\+\\.\\-]{2,}:");
    private static final Pattern ourAnchorSuffix = Pattern.compile("#(.*)$");

    private BrowserUtil() {
    }

    public static boolean isAbsoluteURL(String url) {
        return ourExternalPrefix.matcher(url.toLowerCase(Locale.ENGLISH)).find();
    }

    public static String getDocURL(String url) {
        Matcher anchorMatcher = ourAnchorSuffix.matcher(url);
        return anchorMatcher.find() ? anchorMatcher.reset().replaceAll("") : url;
    }

    @Nullable
    public static URL getURL(String url) throws MalformedURLException {
        return BrowserUtil.isAbsoluteURL(url) ? VfsUtil.convertToURL(url) : new URL("file", "", url);
    }

    public static void browse(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/BrowserUtil", "browse"));
        }
        BrowserUtil.browse(VfsUtil.toUri(file));
    }

    public static void browse(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/BrowserUtil", "browse"));
        }
        BrowserUtil.getBrowserLauncher().browse(file);
    }

    public static void browse(@NotNull URL url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/BrowserUtil", "browse"));
        }
        BrowserUtil.browse(url.toExternalForm());
    }

    @Deprecated
    public static void launchBrowser(@NotNull @NonNls String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/BrowserUtil", "launchBrowser"));
        }
        BrowserUtil.browse(url);
    }

    public static void browse(@NotNull @NonNls String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/BrowserUtil", "browse"));
        }
        BrowserUtil.getBrowserLauncher().browse(url, null);
    }

    private static BrowserLauncher getBrowserLauncher() {
        BrowserLauncher launcher = ApplicationManager.getApplication() == null ? null : BrowserLauncher.getInstance();
        return launcher == null ? new BrowserLauncherAppless() : launcher;
    }

    public static void open(@NotNull @NonNls String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/BrowserUtil", "open"));
        }
        BrowserUtil.getBrowserLauncher().open(url);
    }

    public static void browse(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "com/intellij/ide/BrowserUtil", "browse"));
        }
        BrowserUtil.getBrowserLauncher().browse(uri);
    }

    public static void browse(@NotNull String url, @Nullable Project project) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/ide/BrowserUtil", "browse"));
        }
        BrowserUtil.getBrowserLauncher().browse(url, null, project);
    }

    @Deprecated
    @NotNull
    public static List<String> getOpenBrowserCommand(@NonNls @NotNull String browserPathOrName) {
        if (browserPathOrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserPathOrName", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
        }
        List<String> list = BrowserUtil.getOpenBrowserCommand(browserPathOrName, false);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
        }
        return list;
    }

    @NotNull
    public static List<String> getOpenBrowserCommand(@NonNls @NotNull String browserPathOrName, boolean newWindowIfPossible) {
        if (browserPathOrName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "browserPathOrName", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
        }
        if (new File(browserPathOrName).isFile()) {
            List<String> list = Collections.singletonList(browserPathOrName);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
            }
            return list;
        }
        if (SystemInfo.isMac) {
            ArrayList command = ContainerUtilRt.newArrayList((Object[])new String[]{ExecUtil.getOpenCommandPath(), "-a", browserPathOrName});
            if (newWindowIfPossible) {
                command.add("-n");
            }
            ArrayList arrayList = command;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
            }
            return arrayList;
        }
        if (SystemInfo.isWindows) {
            List<String> list = Arrays.asList(ExecUtil.getWindowsShellName(), "/c", "start", GeneralCommandLine.inescapableQuote(""), browserPathOrName);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
            }
            return list;
        }
        List<String> list = Collections.singletonList(browserPathOrName);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getOpenBrowserCommand"));
        }
        return list;
    }

    public static boolean isOpenCommandSupportArgs() {
        return SystemInfo.isMacOSSnowLeopard;
    }

    @NotNull
    public static String getDefaultAlternativeBrowserPath() {
        if (SystemInfo.isWindows) {
            if ("C:\\Program Files\\Internet Explorer\\IExplore.exe" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getDefaultAlternativeBrowserPath"));
            }
            return "C:\\Program Files\\Internet Explorer\\IExplore.exe";
        }
        if (SystemInfo.isMac) {
            if ("open" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getDefaultAlternativeBrowserPath"));
            }
            return "open";
        }
        if (SystemInfo.isUnix) {
            if ("/usr/bin/firefox" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getDefaultAlternativeBrowserPath"));
            }
            return "/usr/bin/firefox";
        }
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/BrowserUtil", "getDefaultAlternativeBrowserPath"));
        }
        return "";
    }
}

