/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.util.EnvironmentVariable;
import com.intellij.execution.util.ListTableWithButtons;
import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvVariablesTable
extends ListTableWithButtons<EnvironmentVariable> {
    @Override
    protected ListTableModel createListModel() {
        ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> name = new ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable>("Name"){

            public String valueOf(EnvironmentVariable environmentVariable) {
                return environmentVariable.getName();
            }

            public boolean isCellEditable(EnvironmentVariable environmentVariable) {
                return environmentVariable.getNameIsWriteable();
            }

            public void setValue(EnvironmentVariable environmentVariable, String s) {
                if (s.equals(this.valueOf(environmentVariable))) {
                    return;
                }
                environmentVariable.setName(s);
                EnvVariablesTable.this.setModified();
            }

            @Override
            protected String getDescription(EnvironmentVariable environmentVariable) {
                return environmentVariable.getDescription();
            }
        };
        ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable> value = new ListTableWithButtons.ElementsColumnInfoBase<EnvironmentVariable>("Value"){

            public String valueOf(EnvironmentVariable environmentVariable) {
                return environmentVariable.getValue();
            }

            public boolean isCellEditable(EnvironmentVariable environmentVariable) {
                return !environmentVariable.getIsPredefined();
            }

            public void setValue(EnvironmentVariable environmentVariable, String s) {
                if (s.equals(this.valueOf(environmentVariable))) {
                    return;
                }
                environmentVariable.setValue(s);
                EnvVariablesTable.this.setModified();
            }

            @Override
            @Nullable
            protected String getDescription(EnvironmentVariable environmentVariable) {
                return environmentVariable.getDescription();
            }
        };
        return new ListTableModel(new ColumnInfo[]{name, value});
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        return this.getElements();
    }

    @Override
    protected EnvironmentVariable createElement() {
        return new EnvironmentVariable("", "", false);
    }

    @Override
    protected boolean isEmpty(EnvironmentVariable element) {
        return element.getName().isEmpty() && element.getValue().isEmpty();
    }

    @Override
    @NotNull
    protected AnActionButton[] createExtraActions() {
        AnActionButton copyButton = new AnActionButton(ActionsBundle.message("action.EditorCopy.text", new Object[0]), AllIcons.Actions.Copy){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/util/EnvVariablesTable$3", "actionPerformed"));
                }
                EnvVariablesTable.this.stopEditing();
                StringBuilder sb = new StringBuilder();
                List<EnvironmentVariable> variables = EnvVariablesTable.this.getEnvironmentVariables();
                for (EnvironmentVariable environmentVariable : variables) {
                    if (environmentVariable.getIsPredefined() || EnvVariablesTable.this.isEmpty(environmentVariable)) continue;
                    if (sb.length() > 0) {
                        sb.append('\n');
                    }
                    sb.append(StringUtil.escapeChar((String)environmentVariable.getName(), (char)'=')).append('=').append(StringUtil.escapeChar((String)environmentVariable.getValue(), (char)'='));
                }
                CopyPasteManager.getInstance().setContents(new StringSelection(sb.toString()));
            }
        };
        AnActionButton pasteButton = new AnActionButton(ActionsBundle.message("action.EditorPaste.text", new Object[0]), AllIcons.Actions.Menu_paste){

            @Override
            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/execution/util/EnvVariablesTable$4", "actionPerformed"));
                }
                EnvVariablesTable.this.stopEditing();
                String content = (String)CopyPasteManager.getInstance().getContents(DataFlavor.stringFlavor);
                if (content == null || !content.contains("=")) {
                    return;
                }
                ArrayList<EnvironmentVariable> parsed = new ArrayList<EnvironmentVariable>();
                List lines = StringUtil.split((String)content, (String)"\n");
                for (String line : lines) {
                    int pos = line.indexOf(61);
                    if (pos == -1) continue;
                    while (pos > 0 && line.charAt(pos - 1) == '\\') {
                        pos = line.indexOf(61, pos + 1);
                    }
                    parsed.add(new EnvironmentVariable(StringUtil.unescapeStringCharacters((String)line.substring(0, pos)), StringUtil.unescapeStringCharacters((String)line.substring(pos + 1)), false));
                }
                ArrayList<EnvironmentVariable> variables = new ArrayList<EnvironmentVariable>(ContainerUtil.filter(EnvVariablesTable.this.getEnvironmentVariables(), (Condition)new Condition<EnvironmentVariable>(){

                    public boolean value(EnvironmentVariable variable) {
                        return variable.getIsPredefined();
                    }
                }));
                variables.addAll(parsed);
                EnvVariablesTable.this.setValues(variables);
            }
        };
        AnActionButton[] anActionButtonArray = new AnActionButton[]{copyButton, pasteButton};
        if (anActionButtonArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/util/EnvVariablesTable", "createExtraActions"));
        }
        return anActionButtonArray;
    }

    @Override
    protected EnvironmentVariable cloneElement(EnvironmentVariable envVariable) {
        return envVariable.clone();
    }

    @Override
    protected boolean canDeleteElement(EnvironmentVariable selection) {
        return !selection.getIsPredefined();
    }
}

