/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.util.EnvironmentUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SimpleProgramParameters {
    private final ParametersList myProgramParameters = new ParametersList();
    private String myWorkingDirectory;
    private Map<String, String> myEnv = new THashMap();
    private boolean myPassParentEnvs = true;

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(File path) {
        this.setWorkingDirectory(path.getPath());
    }

    public void setWorkingDirectory(String path) {
        this.myWorkingDirectory = path;
    }

    public ParametersList getProgramParametersList() {
        return this.myProgramParameters;
    }

    @NotNull
    public Map<String, String> getEnv() {
        Map<String, String> map = this.myEnv;
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/SimpleProgramParameters", "getEnv"));
        }
        return map;
    }

    public String addEnv(String name, String value) {
        return this.myEnv.put(name, value);
    }

    public void setEnv(Map<String, String> env) {
        this.myEnv = env;
    }

    public boolean isPassParentEnvs() {
        return this.myPassParentEnvs;
    }

    public void setPassParentEnvs(boolean passDefaultEnvs) {
        this.myPassParentEnvs = passDefaultEnvs;
    }

    public void setupEnvs(Map<String, String> envs, boolean passDefault) {
        if (!envs.isEmpty()) {
            HashMap<String, String> map = new HashMap<String, String>(envs);
            EnvironmentUtil.inlineParentOccurrences(map);
            this.setEnv(map);
            this.setPassParentEnvs(passDefault);
        }
    }
}

