/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvidingRunProfile;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchScopeProvider {
    @NotNull
    public static GlobalSearchScope createSearchScope(@NotNull Project project, @Nullable RunProfile runProfile) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/configurations/SearchScopeProvider", "createSearchScope"));
        }
        Module[] modules = null;
        if (runProfile instanceof SearchScopeProvidingRunProfile) {
            modules = ((SearchScopeProvidingRunProfile)runProfile).getModules();
        }
        if (modules == null || modules.length == 0) {
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/SearchScopeProvider", "createSearchScope"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope(modules[0], true);
        for (int idx = 1; idx < modules.length; ++idx) {
            Module module = modules[idx];
            scope = scope.uniteWith(GlobalSearchScope.moduleRuntimeScope(module, true));
        }
        GlobalSearchScope globalSearchScope = scope;
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/configurations/SearchScopeProvider", "createSearchScope"));
        }
        return globalSearchScope;
    }
}

