/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.navigation.PsiElementNavigationItem;
import com.intellij.openapi.util.ClassConditionKey;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LookupElement
extends UserDataHolderBase {
    public static final LookupElement[] EMPTY_ARRAY = new LookupElement[0];

    @NotNull
    public abstract String getLookupString();

    public Set<String> getAllLookupStrings() {
        return Collections.singleton(this.getLookupString());
    }

    @NotNull
    public Object getObject() {
        LookupElement lookupElement = this;
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/LookupElement", "getObject"));
        }
        return lookupElement;
    }

    @Nullable
    public PsiElement getPsiElement() {
        Object o = this.getObject();
        if (o instanceof PsiElement) {
            return (PsiElement)o;
        }
        if (o instanceof ResolveResult) {
            return ((ResolveResult)o).getElement();
        }
        if (o instanceof PsiElementNavigationItem) {
            return ((PsiElementNavigationItem)o).getTargetElement();
        }
        if (o instanceof SmartPsiElementPointer) {
            return ((SmartPsiElementPointer)o).getElement();
        }
        return null;
    }

    public boolean isValid() {
        Object object = this.getObject();
        if (object instanceof PsiElement) {
            return ((PsiElement)object).isValid();
        }
        return true;
    }

    public void handleInsert(InsertionContext context) {
    }

    public String toString() {
        return this.getLookupString();
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setItemText(this.getLookupString());
    }

    @Deprecated
    @Nullable
    public final <T> T as(Class<T> aClass) {
        return this.as(ClassConditionKey.create(aClass));
    }

    @Nullable
    public <T> T as(ClassConditionKey<T> conditionKey) {
        return (T)((Object)(conditionKey.isInstance((Object)this) ? this : null));
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isWorthShowingInAutoPopup() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        this.renderElement(presentation);
        return !presentation.getTailFragments().isEmpty();
    }
}

