/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.util.ClassConditionKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AutoCompletionPolicy {
    NEVER_AUTOCOMPLETE,
    SETTINGS_DEPENDENT,
    GIVE_CHANCE_TO_OVERWRITE,
    ALWAYS_AUTOCOMPLETE;


    @NotNull
    public LookupElement applyPolicy(@NotNull LookupElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/lookup/AutoCompletionPolicy", "applyPolicy"));
        }
        PolicyDecorator policyDecorator = new PolicyDecorator(element, this);
        if (policyDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/lookup/AutoCompletionPolicy", "applyPolicy"));
        }
        return policyDecorator;
    }

    @Nullable
    public static AutoCompletionPolicy getPolicy(LookupElement element) {
        PolicyDecorator decorator = element.as(PolicyDecorator.CLASS_CONDITION_KEY);
        if (decorator != null) {
            return decorator.myPolicy;
        }
        return null;
    }

    private static class PolicyDecorator
    extends LookupElementDecorator<LookupElement> {
        public static final ClassConditionKey<PolicyDecorator> CLASS_CONDITION_KEY = ClassConditionKey.create(PolicyDecorator.class);
        private final AutoCompletionPolicy myPolicy;

        public PolicyDecorator(LookupElement element, AutoCompletionPolicy policy) {
            super(element);
            this.myPolicy = policy;
        }
    }
}

