/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProblemHighlightFilter {
    public static final ExtensionPointName<ProblemHighlightFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.problemHighlightFilter");

    public abstract boolean shouldHighlight(@NotNull PsiFile var1);

    public boolean shouldProcessInBatch(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/codeInsight/daemon/ProblemHighlightFilter", "shouldProcessInBatch"));
        }
        return this.shouldHighlight(psiFile);
    }

    public static boolean shouldHighlightFile(@Nullable PsiFile psiFile) {
        return ProblemHighlightFilter.shouldProcess(psiFile, true);
    }

    public static boolean shouldProcessFileInBatch(@Nullable PsiFile psiFile) {
        return ProblemHighlightFilter.shouldProcess(psiFile, false);
    }

    private static boolean shouldProcess(PsiFile psiFile, boolean onTheFly) {
        ProblemHighlightFilter[] filters;
        if (psiFile == null) {
            return true;
        }
        for (ProblemHighlightFilter filter : filters = (ProblemHighlightFilter[])EP_NAME.getExtensions()) {
            if (!(onTheFly ? !filter.shouldHighlight(psiFile) : !filter.shouldProcessInBatch(psiFile))) continue;
            return false;
        }
        return true;
    }
}

