/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.StringFactory;
import org.jetbrains.annotations.NotNull;

public class ByteArrayCharSequence
implements CharSequence {
    private final byte[] myChars;

    public ByteArrayCharSequence(byte ... chars) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "com/intellij/util/text/ByteArrayCharSequence", "<init>"));
        }
        this.myChars = chars;
    }

    @Override
    public final int length() {
        return this.myChars.length;
    }

    @Override
    public final char charAt(int index) {
        return (char)this.myChars[index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return start == 0 && end == this.length() ? this : new CharSequenceSubSequence(this, start, end);
    }

    @Override
    @NotNull
    public String toString() {
        String string = StringFactory.createShared(CharArrayUtil.fromSequence(this, 0, this.length()));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/ByteArrayCharSequence", "toString"));
        }
        return string;
    }
}

