/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MessageListenerList<T> {
    private final MessageBus myMessageBus;
    private final Topic<T> myTopic;
    private final Map<T, MessageBusConnection> myListenerToConnectionMap;

    public MessageListenerList(@NotNull MessageBus messageBus, @NotNull Topic<T> topic) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageBus", "com/intellij/util/messages/impl/MessageListenerList", "<init>"));
        }
        if (topic == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topic", "com/intellij/util/messages/impl/MessageListenerList", "<init>"));
        }
        this.myListenerToConnectionMap = new ConcurrentHashMap<T, MessageBusConnection>();
        this.myTopic = topic;
        this.myMessageBus = messageBus;
    }

    public void add(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/messages/impl/MessageListenerList", "add"));
        }
        MessageBusConnection connection = this.myMessageBus.connect();
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void add(final @NotNull T listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/messages/impl/MessageListenerList", "add"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/messages/impl/MessageListenerList", "add"));
        }
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                MessageListenerList.this.myListenerToConnectionMap.remove(listener);
            }
        });
        MessageBusConnection connection = this.myMessageBus.connect(parentDisposable);
        connection.subscribe(this.myTopic, listener);
        this.myListenerToConnectionMap.put(listener, connection);
    }

    public void remove(@NotNull T listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/messages/impl/MessageListenerList", "remove"));
        }
        MessageBusConnection connection = this.myListenerToConnectionMap.remove(listener);
        if (connection != null) {
            connection.disconnect();
        }
    }
}

