/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnvironmentUtil {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.EnvironmentUtil");
    private static final int SHELL_ENV_READING_TIMEOUT = 10000;
    private static final Future<Map<String, String>> ourEnvGetter;
    private static final NotNullLazyValue<Map<String, String>> ourEnvironment;
    private static final NotNullLazyValue<Map<String, String>> ourEnvironmentOsSpecific;

    private EnvironmentUtil() {
    }

    public static boolean isEnvironmentReady() {
        return ourEnvGetter.isDone();
    }

    @NotNull
    public static Map<String, String> getEnvironmentMap() {
        Map<String, String> map = ourEnvironment.getValue();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil", "getEnvironmentMap"));
        }
        return map;
    }

    @Nullable
    public static String getValue(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/EnvironmentUtil", "getValue"));
        }
        return ourEnvironmentOsSpecific.getValue().get(name);
    }

    public static String[] getEnvironment() {
        return EnvironmentUtil.flattenEnvironment(EnvironmentUtil.getEnvironmentMap());
    }

    public static String[] flattenEnvironment(Map<String, String> environment) {
        String[] array = new String[environment.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : environment.entrySet()) {
            array[i++] = entry.getKey() + "=" + entry.getValue();
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> getShellEnv() throws Exception {
        String shell = System.getenv("SHELL");
        if (shell == null || !new File(shell).canExecute()) {
            throw new Exception("shell:" + shell);
        }
        File reader = FileUtil.findFirstThatExist(PathManager.getBinPath() + "/printenv.py", PathManager.getHomePath() + "/community/bin/mac/printenv.py", PathManager.getHomePath() + "/bin/mac/printenv.py");
        if (reader == null) {
            throw new Exception("bin:" + PathManager.getBinPath());
        }
        File envFile = FileUtil.createTempFile("intellij-shell-env", null, false);
        try {
            String[] command = new String[]{shell, "-l", "-i", "-c", "'" + reader.getAbsolutePath() + "' '" + envFile.getAbsolutePath() + "'"};
            LOG.info("loading shell env: " + StringUtil.join(command, " "));
            Process process = Runtime.getRuntime().exec(command);
            ProcessKiller processKiller = new ProcessKiller(process);
            processKiller.killAfter(10000L);
            int rv = process.waitFor();
            processKiller.stopWaiting();
            String lines = FileUtil.loadFile(envFile);
            if (rv != 0 || lines.isEmpty()) {
                throw new Exception("rv:" + rv + " text:" + lines.length());
            }
            Map<String, String> map = EnvironmentUtil.parseEnv(lines);
            return map;
        }
        finally {
            FileUtil.delete(envFile);
        }
    }

    private static Map<String, String> parseEnv(String text) throws Exception {
        String[] lines;
        HashSet<String> toIgnore = new HashSet<String>(Arrays.asList("_", "PWD", "SHLVL"));
        Map<String, String> env = System.getenv();
        HashMap<String, String> newEnv = new HashMap<String, String>();
        for (String line : lines = text.split("\u0000")) {
            int pos = line.indexOf(61);
            if (pos <= 0) {
                throw new Exception("malformed:" + line);
            }
            String name = line.substring(0, pos);
            if (!toIgnore.contains(name)) {
                newEnv.put(name, line.substring(pos + 1));
                continue;
            }
            if (!env.containsKey(name)) continue;
            newEnv.put(name, env.get(name));
        }
        LOG.info("shell environment loaded (" + newEnv.size() + " vars)");
        return Collections.unmodifiableMap(newEnv);
    }

    public static Map<String, String> getEnviromentProperties() {
        return EnvironmentUtil.getEnvironmentMap();
    }

    public static Map<String, String> getEnvironmentProperties() {
        return EnvironmentUtil.getEnvironmentMap();
    }

    public static void inlineParentOccurrences(@NotNull Map<String, String> envs) {
        if (envs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "envs", "com/intellij/util/EnvironmentUtil", "inlineParentOccurrences"));
        }
        HashMap<String, String> parentParams = new HashMap<String, String>(System.getenv());
        for (Map.Entry<String, String> entry : envs.entrySet()) {
            String parentVal;
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || (parentVal = (String)parentParams.get(key)) == null || !EnvironmentUtil.containsEnvKeySubstitution(key, value)) continue;
            envs.put(key, value.replace("$" + key + "$", parentVal));
        }
    }

    private static boolean containsEnvKeySubstitution(String envKey, String val) {
        return ArrayUtil.find(val.split(File.pathSeparator), "$" + envKey + "$") != -1;
    }

    static Map<String, String> testLoader() {
        try {
            return EnvironmentUtil.getShellEnv();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static Map<String, String> testParser(@NotNull String lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "com/intellij/util/EnvironmentUtil", "testParser"));
        }
        try {
            return EnvironmentUtil.parseEnv(lines);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        if (SystemInfo.isMac && "unlocked".equals(System.getProperty("__idea.mac.env.lock")) && Registry.is("idea.fix.mac.env")) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            ourEnvGetter = executor.submit(new Callable<Map<String, String>>(){

                @Override
                public Map<String, String> call() throws Exception {
                    try {
                        return EnvironmentUtil.getShellEnv();
                    }
                    catch (Throwable t) {
                        LOG.warn("can't get shell environment", t);
                        return System.getenv();
                    }
                }
            });
            executor.shutdown();
        } else {
            ourEnvGetter = new FixedFuture<Map<String, String>>(System.getenv());
        }
        ourEnvironment = new AtomicNotNullLazyValue<Map<String, String>>(){

            @Override
            @NotNull
            protected Map<String, String> compute() {
                Map map;
                try {
                    map = (Map)ourEnvGetter.get();
                }
                catch (Exception e) {
                    LOG.warn(e);
                    Map<String, String> map2 = System.getenv();
                    if (map2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$2", "compute"));
                    }
                    return map2;
                }
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$2", "compute"));
                }
                return map;
            }
        };
        ourEnvironmentOsSpecific = new AtomicNotNullLazyValue<Map<String, String>>(){

            @Override
            @NotNull
            protected Map<String, String> compute() {
                Map env = (Map)ourEnvironment.getValue();
                if (SystemInfo.isWindows) {
                    env = Collections.unmodifiableMap(new THashMap(env, (TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE));
                }
                Map map = env;
                if (map == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/EnvironmentUtil$3", "compute"));
                }
                return map;
            }
        };
    }

    private static class ProcessKiller {
        private final Process myProcess;
        private final Object myWaiter = new Object();

        public ProcessKiller(Process process) {
            this.myProcess = process;
        }

        public void killAfter(long timeout) {
            final long stop = System.currentTimeMillis() + timeout;
            new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = ProcessKiller.this.myWaiter;
                    synchronized (object) {
                        while (System.currentTimeMillis() < stop) {
                            try {
                                ProcessKiller.this.myProcess.exitValue();
                                break;
                            }
                            catch (IllegalThreadStateException ignore) {
                                try {
                                    ProcessKiller.this.myWaiter.wait(100L);
                                }
                                catch (InterruptedException interruptedException) {}
                            }
                        }
                    }
                    try {
                        ProcessKiller.this.myProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        UnixProcessManager.sendSigKillToProcessTree(ProcessKiller.this.myProcess);
                        LOG.warn("timed out");
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopWaiting() {
            Object object = this.myWaiter;
            synchronized (object) {
                this.myWaiter.notifyAll();
            }
        }
    }
}

