/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.Function;
import org.jetbrains.annotations.NotNull;

public class Pair<A, B> {
    public final A first;
    public final B second;
    private static final Pair EMPTY = Pair.create(null, null);

    @NotNull
    public static <A, B> Pair<A, B> create(A first, B second) {
        Pair<A, B> pair = new Pair<A, B>(first, second);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Pair", "create"));
        }
        return pair;
    }

    @NotNull
    public static <A, B> Pair<A, B> pair(A first, B second) {
        Pair<A, B> pair = new Pair<A, B>(first, second);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Pair", "pair"));
        }
        return pair;
    }

    @NotNull
    public static <A, B> Function<A, Pair<A, B>> createFunction(final B value) {
        Function function = new Function<A, Pair<A, B>>(){

            @Override
            public Pair<A, B> fun(A a) {
                return Pair.create(a, value);
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Pair", "createFunction"));
        }
        return function;
    }

    public static <T> T getFirst(Pair<T, ?> pair) {
        return pair != null ? (T)pair.first : null;
    }

    public static <T> T getSecond(Pair<?, T> pair) {
        return pair != null ? (T)pair.second : null;
    }

    public static <A, B> Pair<A, B> empty() {
        return EMPTY;
    }

    public Pair(A first, B second) {
        this.first = first;
        this.second = second;
    }

    public final A getFirst() {
        return this.first;
    }

    public final B getSecond() {
        return this.second;
    }

    public final boolean equals(Object o) {
        return o instanceof Pair && Comparing.equal(this.first, ((Pair)o).first) && Comparing.equal(this.second, ((Pair)o).second);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.second != null ? this.second.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "<" + this.first + "," + this.second + ">";
    }
}

