/*
 * Decompiled with CFR 0.152.
 */
package com.btr.proxy.selector.whitelist;

import com.btr.proxy.util.UriFilter;
import java.net.URI;

public class HostnameFilter
implements UriFilter {
    private String matchTo;
    private Mode mode;

    public HostnameFilter(Mode mode, String matchTo) {
        this.mode = mode;
        this.matchTo = matchTo.toLowerCase();
    }

    public boolean accept(URI uri) {
        if (uri == null || uri.getAuthority() == null) {
            return false;
        }
        String host = uri.getAuthority();
        int index = host.indexOf(58);
        if (index >= 0) {
            host = host.substring(0, index);
        }
        switch (this.mode) {
            case BEGINS_WITH: {
                return host.toLowerCase().startsWith(this.matchTo);
            }
            case ENDS_WITH: {
                return host.toLowerCase().endsWith(this.matchTo);
            }
            case REGEX: {
                return host.toLowerCase().matches(this.matchTo);
            }
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        BEGINS_WITH,
        ENDS_WITH,
        REGEX;

    }
}

