/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Action;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UntrackedFilesNotifier {
    private UntrackedFilesNotifier() {
    }

    public static void notifyUntrackedFilesOverwrittenBy(final @NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths, final @NotNull String operation, @Nullable String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "git4idea/util/UntrackedFilesNotifier", "notifyUntrackedFilesOverwrittenBy"));
        }
        String notificationTitle = StringUtil.capitalize((String)operation) + " failed";
        String notificationDesc = description == null ? UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operation, true) : description;
        final Collection<String> absolutePaths = GitUtil.toAbsolute(root, relativePaths);
        final List untrackedFiles = ContainerUtil.mapNotNull(absolutePaths, (Function)new Function<String, VirtualFile>(){

            public VirtualFile fun(String absolutePath) {
                return GitUtil.findRefreshFileOrLog(absolutePath);
            }
        });
        VcsNotifier.getInstance((Project)project).notifyError(notificationTitle, notificationDesc, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/util/UntrackedFilesNotifier$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/util/UntrackedFilesNotifier$2", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String dialogDesc = UntrackedFilesNotifier.createUntrackedFilesOverwrittenDescription(operation, false);
                    String title = "Untracked Files Preventing " + StringUtil.capitalize((String)operation);
                    if (untrackedFiles.isEmpty()) {
                        GitUtil.showPathsInDialog(project, absolutePaths, title, dialogDesc);
                    } else {
                        UntrackedFilesDialog dialog = new UntrackedFilesDialog(project, untrackedFiles, dialogDesc);
                        dialog.setTitle(title);
                        dialog.show();
                    }
                }
            }
        });
    }

    public static String createUntrackedFilesOverwrittenDescription(@NotNull String operation, boolean addLinkToViewFiles) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "git4idea/util/UntrackedFilesNotifier", "createUntrackedFilesOverwrittenDescription"));
        }
        String description1 = " untracked working tree files would be overwritten by " + operation + ".";
        String description2 = "Please move or remove them before you can " + operation + ".";
        String notificationDesc = addLinkToViewFiles ? "Some" + description1 + "<br/>" + description2 + " <a href='view'>View them</a>" : "These" + description1 + "<br/>" + description2;
        return notificationDesc;
    }

    private static class UntrackedFilesDialog
    extends SelectFilesDialog {
        public UntrackedFilesDialog(Project project, Collection<VirtualFile> untrackedFiles, String dialogDesc) {
            super(project, new ArrayList<VirtualFile>(untrackedFiles), StringUtil.stripHtml((String)dialogDesc, (boolean)true), null, false, false, true);
            this.init();
        }

        @NotNull
        protected Action[] createActions() {
            Action[] actionArray = new Action[]{this.getOKAction()};
            if (actionArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/UntrackedFilesNotifier$UntrackedFilesDialog", "createActions"));
            }
            return actionArray;
        }
    }
}

