/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ListCellRendererWrapper;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUIUtil {
    public static final String NO_CURRENT_BRANCH = GitBundle.getString("common.no.active.branch");

    private GitUIUtil() {
    }

    public static void notifyMessages(@NotNull Project project, @NotNull String title, @Nullable String description, boolean important, @Nullable Collection<String> messages) {
        String desc;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/GitUIUtil", "notifyMessages"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/util/GitUIUtil", "notifyMessages"));
        }
        String string = desc = description != null ? description.replace("\n", "<br/>") : "";
        if (messages != null && !messages.isEmpty()) {
            desc = desc + StringUtil.join(messages, (String)"<hr/><br/>");
        }
        VcsNotifier notificator = VcsNotifier.getInstance((Project)project);
        if (important) {
            notificator.notifyError(title, desc);
        } else {
            notificator.notifyImportantWarning(title, desc, null);
        }
    }

    public static void notifyMessage(Project project, @NotNull String title, @Nullable String description, boolean important, @Nullable Collection<? extends Exception> errors) {
        HashSet<String> errorMessages;
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/util/GitUIUtil", "notifyMessage"));
        }
        if (errors == null) {
            errorMessages = null;
        } else {
            errorMessages = new HashSet<String>(errors.size());
            for (Exception exception : errors) {
                if (exception instanceof VcsException) {
                    for (String message : ((VcsException)((Object)exception)).getMessages()) {
                        errorMessages.add(message.replace("\n", "<br/>"));
                    }
                    continue;
                }
                errorMessages.add(exception.getMessage().replace("\n", "<br/>"));
            }
        }
        GitUIUtil.notifyMessages(project, title, description, important, errorMessages);
    }

    public static void notifyError(Project project, String title, String description, boolean important, @Nullable Exception error) {
        GitUIUtil.notifyMessage(project, title, description, important, error == null ? null : Collections.singleton(error));
    }

    @NotNull
    public static String stringifyErrors(@Nullable Collection<VcsException> errors) {
        if (errors == null) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitUIUtil", "stringifyErrors"));
            }
            return "";
        }
        StringBuilder content = new StringBuilder();
        for (VcsException e : errors) {
            for (String message : e.getMessages()) {
                content.append(message.replace("\n", "<br/>")).append("<br/>");
            }
        }
        String string = content.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitUIUtil", "stringifyErrors"));
        }
        return string;
    }

    public static void notifyImportantError(Project project, String title, String description) {
        GitUIUtil.notifyMessage(project, title, description, true, null);
    }

    public static void notifyGitErrors(Project project, String title, String description, Collection<VcsException> gitErrors) {
        StringBuilder content = new StringBuilder();
        if (!StringUtil.isEmptyOrSpaces((String)description)) {
            content.append(description);
        }
        if (!gitErrors.isEmpty()) {
            content.append("<br/>");
        }
        for (VcsException e : gitErrors) {
            content.append(e.getLocalizedMessage()).append("<br/>");
        }
        GitUIUtil.notifyMessage(project, title, content.toString(), false, null);
    }

    public static ListCellRendererWrapper<VirtualFile> getVirtualFileListCellRenderer() {
        return new ListCellRendererWrapper<VirtualFile>(){

            public void customize(JList list, VirtualFile file, int index, boolean selected, boolean hasFocus) {
                this.setText(file == null ? "(invalid)" : file.getPresentableUrl());
            }
        };
    }

    public static JTextField getTextField(JComboBox comboBox) {
        return (JTextField)comboBox.getEditor().getEditorComponent();
    }

    public static void setupRootChooser(final @NotNull Project project, @NotNull List<VirtualFile> roots, @Nullable VirtualFile defaultRoot, final @NotNull JComboBox gitRootChooser, final @Nullable JLabel currentBranchLabel) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/util/GitUIUtil", "setupRootChooser"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/util/GitUIUtil", "setupRootChooser"));
        }
        if (gitRootChooser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRootChooser", "git4idea/util/GitUIUtil", "setupRootChooser"));
        }
        for (VirtualFile root : roots) {
            gitRootChooser.addItem(root);
        }
        gitRootChooser.setRenderer(GitUIUtil.getVirtualFileListCellRenderer());
        gitRootChooser.setSelectedItem(defaultRoot != null ? defaultRoot : roots.get(0));
        if (currentBranchLabel != null) {
            ActionListener listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    VirtualFile root = (VirtualFile)gitRootChooser.getSelectedItem();
                    assert (root != null) : "The root must not be null";
                    GitRepository repo = (GitRepository)GitUtil.getRepositoryManager(project).getRepositoryForRoot(root);
                    assert (repo != null) : "The repository must not be null";
                    GitLocalBranch current = repo.getCurrentBranch();
                    if (current == null) {
                        currentBranchLabel.setText(NO_CURRENT_BRANCH);
                    } else {
                        currentBranchLabel.setText(current.getName());
                    }
                }
            };
            listener.actionPerformed(null);
            gitRootChooser.addActionListener(listener);
        }
    }

    public static void showOperationError(Project project, VcsException ex, @NonNls @NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "git4idea/util/GitUIUtil", "showOperationError"));
        }
        GitUIUtil.showOperationError(project, operation, ex.getMessage());
    }

    public static void showOperationErrors(Project project, Collection<VcsException> exs, @NonNls @NotNull String operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "git4idea/util/GitUIUtil", "showOperationErrors"));
        }
        if (exs.size() == 1) {
            GitUIUtil.showOperationError(project, operation, exs.iterator().next().getMessage());
        } else if (exs.size() > 1) {
            StringBuilder b = new StringBuilder();
            for (VcsException ex : exs) {
                b.append(GitBundle.message("errors.message.item", ex.getMessage()));
            }
            GitUIUtil.showOperationError(project, operation, GitBundle.message("errors.message", b.toString()));
        }
    }

    public static void showOperationError(Project project, String operation, String message) {
        Messages.showErrorDialog((Project)project, (String)message, (String)GitBundle.message("error.occurred.during", operation));
    }

    public static void showTabErrors(Project project, String title, List<VcsException> errors) {
        AbstractVcsHelper.getInstance((Project)project).showErrors(errors, title);
    }

    public static void imply(final JCheckBox checked, final boolean checkedState, final JCheckBox changed, final boolean impliedState) {
        ActionListener l = new ActionListener(){
            Boolean previousState;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checked.isSelected() == checkedState) {
                    if (this.previousState == null) {
                        this.previousState = changed.isSelected();
                    }
                    changed.setEnabled(false);
                    changed.setSelected(impliedState);
                } else {
                    changed.setEnabled(true);
                    if (this.previousState != null) {
                        changed.setSelected(this.previousState);
                        this.previousState = null;
                    }
                }
            }
        };
        checked.addActionListener(l);
        l.actionPerformed(null);
    }

    public static void exclusive(final JCheckBox first, final boolean firstState, final JCheckBox second, final boolean secondState) {
        ActionListener l = new ActionListener(){

            private void check(JCheckBox checked, boolean checkedState, JCheckBox changed, boolean impliedState) {
                if (checked.isSelected() == checkedState) {
                    changed.setSelected(impliedState);
                    changed.setEnabled(false);
                } else {
                    changed.setEnabled(true);
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.check(first, firstState, second, !secondState);
                this.check(second, secondState, first, !firstState);
            }
        };
        first.addActionListener(l);
        second.addActionListener(l);
        l.actionPerformed(null);
    }

    public static void implyDisabled(final JCheckBox checked, final boolean checkedState, final JTextComponent changed) {
        ActionListener l = new ActionListener(){
            String previousState;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (checked.isSelected() == checkedState) {
                    if (this.previousState == null) {
                        this.previousState = changed.getText();
                    }
                    changed.setEnabled(false);
                    changed.setText("");
                } else {
                    changed.setEnabled(true);
                    if (this.previousState != null) {
                        changed.setText(this.previousState);
                        this.previousState = null;
                    }
                }
            }
        };
        checked.addActionListener(l);
        l.actionPerformed(null);
    }

    public static String bold(String s) {
        return GitUIUtil.surround(s, "b");
    }

    public static String code(String s) {
        return GitUIUtil.surround(s, "code");
    }

    private static String surround(String s, String tag) {
        return String.format("<%2$s>%1$s</%2$s>", s, tag);
    }
}

