/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Clock;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.impl.LocalChangesUnderRoots;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.continuation.ContinuationContext;
import com.intellij.util.continuation.ContinuationFinalTasksInserter;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import com.intellij.util.text.DateFormatUtil;
import git4idea.GitLocalBranch;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.branch.GitBranchPair;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.merge.GitMergeCommittingConflictResolver;
import git4idea.merge.GitMerger;
import git4idea.rebase.GitRebaser;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import git4idea.update.GitComplexProcess;
import git4idea.update.GitFetcher;
import git4idea.update.GitMergeUpdater;
import git4idea.update.GitRebaseUpdater;
import git4idea.update.GitUpdateResult;
import git4idea.update.GitUpdater;
import git4idea.util.GitUIUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUpdateProcess {
    private static final Logger LOG = Logger.getInstance(GitUpdateProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final Collection<GitRepository> myRepositories;
    private final UpdatedFiles myUpdatedFiles;
    private final ProgressIndicator myProgressIndicator;
    private final GitMerger myMerger;
    private final GitChangesSaver mySaver;
    private final Map<VirtualFile, GitBranchPair> myTrackedBranches;
    private GitUpdateResult myResult;
    private final Collection<VirtualFile> myRootsToSave;

    public GitUpdateProcess(@NotNull Project project, @NotNull GitPlatformFacade platformFacade, @Nullable ProgressIndicator progressIndicator, @NotNull Collection<GitRepository> repositories, @NotNull UpdatedFiles updatedFiles) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        if (platformFacade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platformFacade", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        if (updatedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updatedFiles", "git4idea/update/GitUpdateProcess", "<init>"));
        }
        this.myTrackedBranches = new HashMap<VirtualFile, GitBranchPair>();
        this.myProject = project;
        this.myRepositories = repositories;
        this.myGit = (Git)ServiceManager.getService(Git.class);
        this.myUpdatedFiles = updatedFiles;
        this.myProgressIndicator = progressIndicator == null ? new EmptyProgressIndicator() : progressIndicator;
        this.myMerger = new GitMerger(this.myProject);
        this.mySaver = GitChangesSaver.getSaver(this.myProject, platformFacade, this.myGit, this.myProgressIndicator, "Uncommitted changes before update operation at " + DateFormatUtil.formatDateTime((long)Clock.getTime()));
        this.myRootsToSave = new HashSet<VirtualFile>(1);
    }

    @NotNull
    public GitUpdateResult update(final UpdateMethod updateMethod) {
        LOG.info("update started|" + (Object)((Object)updateMethod));
        String oldText = this.myProgressIndicator.getText();
        this.myProgressIndicator.setText("Updating...");
        for (GitRepository repository : this.myRepositories) {
            repository.update();
        }
        if (this.checkRebaseInProgress() || this.isMergeInProgress() || this.areUnmergedFiles() || !this.checkTrackedBranchesConfigured()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
            }
            return gitUpdateResult;
        }
        if (!this.fetchAndNotify()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOT_READY;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
            }
            return gitUpdateResult;
        }
        GitComplexProcess.Operation updateOperation = new GitComplexProcess.Operation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run(ContinuationContext continuationContext) {
                DvcsUtil.workingTreeChangeStarted((Project)GitUpdateProcess.this.myProject);
                try {
                    GitUpdateProcess.this.myResult = GitUpdateProcess.this.updateImpl(updateMethod, continuationContext);
                }
                finally {
                    DvcsUtil.workingTreeChangeFinished((Project)GitUpdateProcess.this.myProject);
                }
            }
        };
        GitComplexProcess.execute(this.myProject, "update", updateOperation);
        this.myProgressIndicator.setText(oldText);
        GitUpdateResult gitUpdateResult = this.myResult;
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "update"));
        }
        return gitUpdateResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private GitUpdateResult updateImpl(@NotNull UpdateMethod updateMethod, ContinuationContext context) {
        Map<VirtualFile, GitUpdater> updaters;
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMethod", "git4idea/update/GitUpdateProcess", "updateImpl"));
        }
        try {
            updaters = this.defineUpdaters(updateMethod);
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
            GitUIUtil.notifyError(this.myProject, "Git update failed", e.getMessage(), true, (Exception)((Object)e));
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        if (updaters.isEmpty()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.NOTHING_TO_UPDATE;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        if ((updaters = this.tryFastForwardMergeForRebaseUpdaters(updaters)).isEmpty()) {
            GitUpdateResult gitUpdateResult = GitUpdateResult.SUCCESS;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        LOG.info("updateImpl: identifying if save is needed...");
        for (Map.Entry<VirtualFile, GitUpdater> entry : updaters.entrySet()) {
            VirtualFile root = entry.getKey();
            GitUpdater updater = entry.getValue();
            if (!updater.isSaveNeeded()) continue;
            this.myRootsToSave.add(root);
            LOG.info("update| root " + root + " needs save");
        }
        LOG.info("updateImpl: saving local changes...");
        try {
            this.mySaver.saveLocalChanges(this.myRootsToSave);
        }
        catch (VcsException e) {
            LOG.info("Couldn't save local changes", (Throwable)e);
            GitUIUtil.notifyError(this.myProject, "Git update failed", "Tried to save uncommitted changes in " + this.mySaver.getSaverName() + " before update, but failed with an error.<br/>" + "Update was cancelled.", true, (Exception)((Object)e));
            GitUpdateResult gitUpdateResult = GitUpdateResult.ERROR;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
            }
            return gitUpdateResult;
        }
        LOG.info("updateImpl: updating...");
        boolean incomplete = false;
        GitUpdateResult compoundResult = null;
        VirtualFile currentlyUpdatedRoot = null;
        try {
            for (Map.Entry<VirtualFile, GitUpdater> entry : updaters.entrySet()) {
                currentlyUpdatedRoot = entry.getKey();
                GitUpdater updater = entry.getValue();
                GitUpdateResult res = updater.update();
                LOG.info("updating root " + currentlyUpdatedRoot + " finished: " + (Object)((Object)res));
                if (res == GitUpdateResult.INCOMPLETE) {
                    incomplete = true;
                }
                compoundResult = GitUpdateProcess.joinResults(compoundResult, res);
            }
        }
        catch (VcsException e) {
            String rootName = currentlyUpdatedRoot == null ? "" : currentlyUpdatedRoot.getName();
            LOG.info("Error updating changes for root " + currentlyUpdatedRoot, (Throwable)e);
            GitUIUtil.notifyImportantError(this.myProject, "Error updating " + rootName, "Updating " + rootName + " failed with an error: " + e.getLocalizedMessage());
        }
        finally {
            if (incomplete || compoundResult == null || !compoundResult.isSuccess()) {
                this.mySaver.notifyLocalChangesAreNotRestored();
            } else {
                LOG.info("updateImpl: restoring local changes...");
                this.restoreLocalChanges(context);
            }
        }
        GitUpdateResult gitUpdateResult = compoundResult;
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "updateImpl"));
        }
        return gitUpdateResult;
    }

    @NotNull
    private Map<VirtualFile, GitUpdater> tryFastForwardMergeForRebaseUpdaters(@NotNull Map<VirtualFile, GitUpdater> updaters) {
        if (updaters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updaters", "git4idea/update/GitUpdateProcess", "tryFastForwardMergeForRebaseUpdaters"));
        }
        HashMap<VirtualFile, GitUpdater> modifiedUpdaters = new HashMap<VirtualFile, GitUpdater>();
        Map changesUnderRoots = new LocalChangesUnderRoots(ChangeListManager.getInstance((Project)this.myProject), ProjectLevelVcsManager.getInstance((Project)this.myProject)).getChangesUnderRoots(updaters.keySet());
        for (Map.Entry<VirtualFile, GitUpdater> updaterEntry : updaters.entrySet()) {
            GitRebaseUpdater rebaseUpdater;
            VirtualFile root = updaterEntry.getKey();
            GitUpdater updater = updaterEntry.getValue();
            Collection changes = (Collection)changesUnderRoots.get(root);
            if (updater instanceof GitRebaseUpdater && changes != null && !changes.isEmpty() && (rebaseUpdater = (GitRebaseUpdater)updater).fastForwardMerge()) continue;
            modifiedUpdaters.put(root, updater);
        }
        HashMap<VirtualFile, GitUpdater> hashMap = modifiedUpdaters;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "tryFastForwardMergeForRebaseUpdaters"));
        }
        return hashMap;
    }

    @NotNull
    private Map<VirtualFile, GitUpdater> defineUpdaters(@NotNull UpdateMethod updateMethod) throws VcsException {
        if (updateMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateMethod", "git4idea/update/GitUpdateProcess", "defineUpdaters"));
        }
        HashMap<VirtualFile, GitUpdater> updaters = new HashMap<VirtualFile, GitUpdater>();
        LOG.info("updateImpl: defining updaters...");
        for (GitRepository repository : this.myRepositories) {
            VirtualFile root = repository.getRoot();
            GitUpdater updater = updateMethod == UpdateMethod.MERGE ? new GitMergeUpdater(this.myProject, this.myGit, root, this.myTrackedBranches, this.myProgressIndicator, this.myUpdatedFiles) : (updateMethod == UpdateMethod.REBASE ? new GitRebaseUpdater(this.myProject, this.myGit, root, this.myTrackedBranches, this.myProgressIndicator, this.myUpdatedFiles) : GitUpdater.getUpdater(this.myProject, this.myGit, this.myTrackedBranches, root, this.myProgressIndicator, this.myUpdatedFiles));
            if (updater.isUpdateNeeded()) {
                updaters.put(root, updater);
            }
            LOG.info("update| root=" + root + " ,updater=" + updater);
        }
        HashMap<VirtualFile, GitUpdater> hashMap = updaters;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "defineUpdaters"));
        }
        return hashMap;
    }

    @NotNull
    private static GitUpdateResult joinResults(@Nullable GitUpdateResult compoundResult, GitUpdateResult result) {
        if (compoundResult == null) {
            GitUpdateResult gitUpdateResult = result;
            if (gitUpdateResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "joinResults"));
            }
            return gitUpdateResult;
        }
        GitUpdateResult gitUpdateResult = compoundResult.join(result);
        if (gitUpdateResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/update/GitUpdateProcess", "joinResults"));
        }
        return gitUpdateResult;
    }

    private void restoreLocalChanges(ContinuationContext context) {
        context.addExceptionHandler(VcsException.class, (Consumer)new Consumer<VcsException>(){

            public void consume(VcsException e) {
                LOG.info("Couldn't restore local changes after update", (Throwable)e);
                GitUIUtil.notifyImportantError(GitUpdateProcess.this.myProject, "Couldn't restore local changes after update", "Restoring changes saved before update failed with an error.<br/>" + e.getLocalizedMessage());
            }
        });
        ContinuationFinalTasksInserter finalTasksInserter = new ContinuationFinalTasksInserter(context);
        finalTasksInserter.allNextAreFinal();
        context.next(new TaskDescriptor[]{new TaskDescriptor("Refresh local files", Where.POOLED){

            public void run(ContinuationContext context) {
                GitUpdateProcess.this.mySaver.refresh();
            }
        }});
        this.mySaver.restoreLocalChanges(context);
        finalTasksInserter.removeFinalPropertyAdder();
    }

    private boolean fetchAndNotify() {
        return new GitFetcher(this.myProject, this.myProgressIndicator, false).fetchRootsAndNotify(this.myRepositories, "Update failed", false);
    }

    private boolean checkTrackedBranchesConfigured() {
        LOG.info("checking tracked branch configuration...");
        for (GitRepository repository : this.myRepositories) {
            VirtualFile root = repository.getRoot();
            GitLocalBranch branch = repository.getCurrentBranch();
            if (branch == null) {
                LOG.info("checkTrackedBranchesConfigured: current branch is null in " + repository);
                GitUIUtil.notifyImportantError(this.myProject, "Can't update: no current branch", "You are in 'detached HEAD' state, which means that you're not on any branch" + this.rootStringIfNeeded(root) + "Checkout a branch to make update possible.");
                return false;
            }
            GitBranchTrackInfo trackInfo = GitBranchUtil.getTrackInfoForBranch(repository, branch);
            if (trackInfo == null) {
                String branchName = branch.getName();
                LOG.info(String.format("checkTrackedBranchesConfigured: no track info for current branch %s in %s", branch, repository));
                GitUIUtil.notifyImportantError(this.myProject, "Can't update: no tracked branch", "No tracked branch configured for branch " + GitUIUtil.code(branchName) + this.rootStringIfNeeded(root) + "To make your branch track a remote branch call, for example,<br/>" + "<code>git branch --set-upstream " + branchName + " origin/" + branchName + "</code>");
                return false;
            }
            this.myTrackedBranches.put(root, new GitBranchPair(branch, trackInfo.getRemoteBranch()));
        }
        return true;
    }

    private String rootStringIfNeeded(@NotNull VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/update/GitUpdateProcess", "rootStringIfNeeded"));
        }
        if (this.myRepositories.size() < 2) {
            return ".<br/>";
        }
        return "<br/>in Git repository " + GitUIUtil.code(root.getPresentableUrl()) + "<br/>";
    }

    private boolean isMergeInProgress() {
        LOG.info("isMergeInProgress: checking if there is an unfinished merge process...");
        Collection<VirtualFile> mergingRoots = this.myMerger.getMergingRoots();
        if (mergingRoots.isEmpty()) {
            return false;
        }
        LOG.info("isMergeInProgress: roots with unfinished merge: " + mergingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished merge. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, mergingRoots, params, false).merge();
    }

    private boolean areUnmergedFiles() {
        LOG.info("areUnmergedFiles: checking if there are unmerged files...");
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Update was not started");
        params.setMergeDescription("Unmerged files detected. These conflicts must be resolved before update.");
        return !new GitMergeCommittingConflictResolver(this.myProject, this.myGit, this.myMerger, GitUtil.getRootsFromRepositories(this.myRepositories), params, false).merge();
    }

    private boolean checkRebaseInProgress() {
        LOG.info("checkRebaseInProgress: checking if there is an unfinished rebase process...");
        final GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, this.myProgressIndicator);
        final Collection<VirtualFile> rebasingRoots = rebaser.getRebasingRoots();
        if (rebasingRoots.isEmpty()) {
            return false;
        }
        LOG.info("checkRebaseInProgress: roots with unfinished rebase: " + rebasingRoots);
        GitConflictResolver.Params params = new GitConflictResolver.Params();
        params.setErrorNotificationTitle("Can't update");
        params.setMergeDescription("You have unfinished rebase process. These conflicts must be resolved before update.");
        params.setErrorNotificationAdditionalDescription("Then you may <b>continue rebase</b>. <br/> You also may <b>abort rebase</b> to restore the original branch and stop rebasing.");
        params.setReverse(true);
        return !new GitConflictResolver(this.myProject, this.myGit, (GitPlatformFacade)ServiceManager.getService(GitPlatformFacade.class), rebasingRoots, params){

            @Override
            protected boolean proceedIfNothingToMerge() {
                return rebaser.continueRebase(rebasingRoots);
            }

            @Override
            protected boolean proceedAfterAllMerged() {
                return rebaser.continueRebase(rebasingRoots);
            }
        }.merge();
    }

    public static enum UpdateMethod {
        MERGE,
        REBASE,
        READ_FROM_SETTINGS;

    }
}

