/*
 * Decompiled with CFR 0.152.
 */
package git4idea.update;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import git4idea.config.GitVcsSettings;
import git4idea.config.UpdateMethod;
import git4idea.i18n.GitBundle;
import git4idea.update.UpdatePolicyUtils;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

public class GitUpdateOptionsPanel {
    private JPanel myPanel;
    private JRadioButton myBranchDefaultRadioButton;
    private JRadioButton myForceRebaseRadioButton;
    private JRadioButton myForceMergeRadioButton;
    private JRadioButton myStashRadioButton;
    private JRadioButton myShelveRadioButton;

    public GitUpdateOptionsPanel() {
        this.$$$setupUI$$$();
    }

    public JComponent getPanel() {
        return this.myPanel;
    }

    public boolean isModified(GitVcsSettings settings) {
        UpdateMethod type = this.getUpdateType();
        return type != settings.getUpdateType() || this.updateSaveFilesPolicy() != settings.updateChangesPolicy();
    }

    private GitVcsSettings.UpdateChangesPolicy updateSaveFilesPolicy() {
        return UpdatePolicyUtils.getUpdatePolicy(this.myStashRadioButton, this.myShelveRadioButton);
    }

    private UpdateMethod getUpdateType() {
        UpdateMethod type = null;
        if (this.myForceRebaseRadioButton.isSelected()) {
            type = UpdateMethod.REBASE;
        } else if (this.myForceMergeRadioButton.isSelected()) {
            type = UpdateMethod.MERGE;
        } else if (this.myBranchDefaultRadioButton.isSelected()) {
            type = UpdateMethod.BRANCH_DEFAULT;
        }
        assert (type != null);
        return type;
    }

    public void applyTo(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/update/GitUpdateOptionsPanel", "applyTo"));
        }
        settings.setUpdateType(this.getUpdateType());
        settings.setUpdateChangesPolicy(this.updateSaveFilesPolicy());
    }

    public void updateFrom(@NotNull GitVcsSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "git4idea/update/GitUpdateOptionsPanel", "updateFrom"));
        }
        switch (settings.getUpdateType()) {
            case REBASE: {
                this.myForceRebaseRadioButton.setSelected(true);
                break;
            }
            case MERGE: {
                this.myForceMergeRadioButton.setSelected(true);
                break;
            }
            case BRANCH_DEFAULT: {
                this.myBranchDefaultRadioButton.setSelected(true);
                break;
            }
            default: {
                assert (false) : "Unknown value of update type: " + (Object)((Object)settings.getUpdateType());
                break;
            }
        }
        UpdatePolicyUtils.updatePolicyItem(settings.updateChangesPolicy(), this.myStashRadioButton, this.myShelveRadioButton);
    }

    private void createUIComponents() {
        this.myShelveRadioButton = new JRadioButton(GitBundle.message("update.options.save.shelve", new Object[0]));
        this.myShelveRadioButton.setToolTipText(GitBundle.message("update.options.save.shelve.tooltip", ApplicationNamesInfo.getInstance().getFullProductName()));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JRadioButton jRadioButton4;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 10, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type"), (int)0, (int)0, null, null));
        this.myForceMergeRadioButton = jRadioButton4 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton4, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.merge"));
        jRadioButton4.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.merge.tooltip"));
        jPanel2.add((Component)jRadioButton4, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myForceRebaseRadioButton = jRadioButton3 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.rebase"));
        jRadioButton3.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.rebase.tooltip"));
        jPanel2.add((Component)jRadioButton3, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myBranchDefaultRadioButton = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.default"));
        jRadioButton2.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.type.default.tooltip"));
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 100), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 1, 1, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.save.before.update"), (int)0, (int)0, null, null));
        this.myStashRadioButton = jRadioButton = new JRadioButton();
        jRadioButton.setSelected(true);
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.save.stash"));
        jRadioButton.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("update.options.save.stash.tooltip"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton5 = this.myShelveRadioButton;
        jRadioButton5.setSelected(false);
        jPanel3.add((Component)jRadioButton5, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.add(jRadioButton4);
        buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton5);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

