/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class GitRebaseUnstructuredEditor
extends DialogWrapper {
    private JTextArea myTextArea;
    private JPanel myPanel;
    private JLabel myGitRootLabel;
    private final String encoding;
    private final File myFile;

    protected GitRebaseUnstructuredEditor(Project project, VirtualFile root, String path) throws IOException {
        super(project, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(GitBundle.message("rebase.unstructured.editor.title", objectArray));
        this.setOKButtonText(GitBundle.message("rebase.unstructured.editor.button", new Object[0]));
        this.myGitRootLabel.setText(root.getPresentableUrl());
        this.encoding = GitConfigUtil.getCommitEncoding(project, root);
        this.myFile = new File(path);
        this.myTextArea.setText(FileUtil.loadFile((File)this.myFile, (String)this.encoding));
        this.myTextArea.setCaretPosition(0);
        this.init();
    }

    public void save() throws IOException {
        FileUtil.writeToFile((File)this.myFile, (byte[])this.myTextArea.getText().getBytes(this.encoding));
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected String getDimensionServiceKey() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTextArea;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JTextArea jTextArea;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.unstructured.editor.message"));
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(2, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myTextArea = jTextArea = new JTextArea();
        jTextArea.setToolTipText(ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.unstructured.editor.tooltip"));
        jBScrollPane.setViewportView(jTextArea);
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("git4idea/i18n/GitBundle").getString("rebase.unstructured.editor.git.root"));
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myGitRootLabel = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        jLabel2.setLabelFor(jTextArea);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

