/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.actions.GitRepositoryAction;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitTask;
import git4idea.commands.GitTaskResult;
import git4idea.commands.GitTaskResultHandlerAdapter;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorService;
import git4idea.rebase.GitRebaseLineListener;
import git4idea.repo.GitRepositoryManager;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GitRebaseActionBase
extends GitRepositoryAction {
    @Override
    protected void perform(final @NotNull Project project, @NotNull List<VirtualFile> gitRoots, @NotNull VirtualFile defaultRoot, Set<VirtualFile> affectedRoots, final List<VcsException> exceptions) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/actions/GitRebaseActionBase", "perform"));
        }
        if (gitRoots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gitRoots", "git4idea/actions/GitRebaseActionBase", "perform"));
        }
        if (defaultRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultRoot", "git4idea/actions/GitRebaseActionBase", "perform"));
        }
        GitLineHandler h = this.createHandler(project, gitRoots, defaultRoot);
        if (h == null) {
            return;
        }
        final VirtualFile root = h.workingDirectoryFile();
        GitRebaseEditorService service = GitRebaseEditorService.getInstance();
        final GitInteractiveRebaseEditorHandler editor = new GitInteractiveRebaseEditorHandler(service, project, root, h);
        final GitRebaseLineListener resultListener = new GitRebaseLineListener();
        h.addLineListener(resultListener);
        this.configureEditor(editor);
        affectedRoots.add(root);
        service.configureHandler(h, editor.getHandlerNo());
        GitTask task = new GitTask(project, h, GitBundle.getString("rebasing.title"));
        task.executeInBackground(false, new GitTaskResultHandlerAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void run(GitTaskResult taskResult) {
                DvcsUtil.workingTreeChangeStarted((Project)project);
                try {
                    editor.close();
                    GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
                    manager.updateRepository(root);
                    root.refresh(false, true);
                    GitRebaseActionBase.notifyAboutErrorResult(taskResult, resultListener, exceptions, project);
                }
                finally {
                    DvcsUtil.workingTreeChangeFinished((Project)project);
                }
            }
        });
    }

    private static void notifyAboutErrorResult(GitTaskResult taskResult, GitRebaseLineListener resultListener, List<VcsException> exceptions, Project project) {
        String title;
        String message;
        String messageId;
        if (taskResult == GitTaskResult.CANCELLED) {
            return;
        }
        GitRebaseLineListener.Result result = resultListener.getResult();
        boolean isError = true;
        switch (result.status) {
            case CONFLICT: {
                messageId = "rebase.result.conflict";
                break;
            }
            case ERROR: {
                messageId = "rebase.result.error";
                break;
            }
            case CANCELLED: {
                exceptions.clear();
                return;
            }
            case EDIT: {
                isError = false;
                messageId = "rebase.result.amend";
                break;
            }
            case FINISHED: {
                isError = false;
                messageId = "rebase.result.success";
                break;
            }
            default: {
                messageId = null;
            }
        }
        if (messageId != null) {
            message = GitBundle.message(messageId, result.current, result.total);
            title = GitBundle.message(messageId + ".title", new Object[0]);
        } else {
            message = "Rebase finished: " + StringUtil.capitalize((String)StringUtil.toLowerCase((String)result.status.name()));
            title = "";
        }
        if (isError) {
            Messages.showErrorDialog((Project)project, (String)message, (String)title);
        } else {
            Messages.showInfoMessage((Project)project, (String)message, (String)title);
        }
    }

    protected void configureEditor(GitInteractiveRebaseEditorHandler editor) {
    }

    @Nullable
    protected abstract GitLineHandler createHandler(Project var1, List<VirtualFile> var2, VirtualFile var3);
}

