/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.importProject;

import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.ide.util.projectWizard.importSources.impl.JavaProjectStructureDetector;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.util.CloudGitDeploymentDetector;
import com.intellij.remoteServer.util.importProject.CloudGitChooseAccountStepImpl;
import com.intellij.remoteServer.util.importProject.CloudGitJavaSourceRoot;
import com.intellij.remoteServer.util.importProject.CloudGitProjectRoot;
import git4idea.GitPlatformFacade;
import git4idea.GitUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class CloudGitProjectStructureDetector
extends ProjectStructureDetector {
    private final JavaProjectStructureDetector myJavaDetector = new JavaProjectStructureDetector();

    @NotNull
    public ProjectStructureDetector.DirectoryProcessingResult detectRoots(@NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectRoots"));
        }
        CloudGitProjectStructureDetector.detectApplicationRoot(dir, result);
        for (DetectedProjectRoot projectRoot : result) {
            if (!(projectRoot instanceof CloudGitProjectRoot) || !FileUtil.isAncestor((File)projectRoot.getDirectory(), (File)dir, (boolean)true)) continue;
            ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = this.detectJavaRoots(((CloudGitProjectRoot)projectRoot).getJavaSourceRootTypeName(), dir, children, base, result);
            if (directoryProcessingResult == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectRoots"));
            }
            return directoryProcessingResult;
        }
        ProjectStructureDetector.DirectoryProcessingResult directoryProcessingResult = ProjectStructureDetector.DirectoryProcessingResult.PROCESS_CHILDREN;
        if (directoryProcessingResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectRoots"));
        }
        return directoryProcessingResult;
    }

    private static void detectApplicationRoot(@NotNull File dir, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectApplicationRoot"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectApplicationRoot"));
        }
        VirtualFile repositoryRoot = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(dir);
        if (repositoryRoot == null) {
            return;
        }
        if (GitUtil.findGitDir((VirtualFile)repositoryRoot) == null) {
            return;
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        GitRepository repository = GitRepositoryImpl.getLightInstance((VirtualFile)repositoryRoot, (Project)project, (GitPlatformFacade)((GitPlatformFacade)ServiceManager.getService((Project)project, GitPlatformFacade.class)), (Disposable)project);
        repository.update();
        for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])CloudGitDeploymentDetector.EP_NAME.getExtensions()) {
            String applicationName = deploymentDetector.getFirstApplicationName(repository);
            if (applicationName == null) continue;
            result.add(new CloudGitProjectRoot(deploymentDetector, dir, repositoryRoot, applicationName));
        }
    }

    private ProjectStructureDetector.DirectoryProcessingResult detectJavaRoots(String javaSourceRootTypeName, @NotNull File dir, @NotNull File[] children, @NotNull File base, @NotNull List<DetectedProjectRoot> result) {
        if (dir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dir", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectJavaRoots"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectJavaRoots"));
        }
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectJavaRoots"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/remoteServer/util/importProject/CloudGitProjectStructureDetector", "detectJavaRoots"));
        }
        ArrayList detectedJavaRoots = new ArrayList();
        ProjectStructureDetector.DirectoryProcessingResult processingResult = this.myJavaDetector.detectRoots(dir, children, base, detectedJavaRoots);
        for (DetectedProjectRoot detectedJavaRoot : detectedJavaRoots) {
            if (!(detectedJavaRoot instanceof JavaModuleSourceRoot)) continue;
            result.add((DetectedProjectRoot)new CloudGitJavaSourceRoot(javaSourceRootTypeName, (JavaModuleSourceRoot)detectedJavaRoot));
        }
        return processingResult;
    }

    public List<ModuleWizardStep> createWizardSteps(ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, Icon stepIcon) {
        ArrayList<ModuleWizardStep> result = new ArrayList<ModuleWizardStep>();
        for (CloudGitDeploymentDetector deploymentDetector : (CloudGitDeploymentDetector[])CloudGitDeploymentDetector.EP_NAME.getExtensions()) {
            result.add(new CloudGitChooseAccountStepImpl(deploymentDetector, this, builder, projectDescriptor));
        }
        return result;
    }
}

