/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.util.text.StringUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.util.Date;
import javax.activation.MimetypesFileTypeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.Responses;

public class FileResponses {
    private static final MimetypesFileTypeMap FILE_MIMETYPE_MAP = new MimetypesFileTypeMap();

    public static String getContentType(String path) {
        return FILE_MIMETYPE_MAP.getContentType(path);
    }

    private static boolean checkCache(HttpRequest request, Channel channel, long lastModified) {
        String ifModifiedSince = request.headers().get("If-Modified-Since");
        if (!StringUtil.isEmpty((String)ifModifiedSince)) {
            try {
                if (Responses.DATE_FORMAT.get().parse(ifModifiedSince).getTime() >= lastModified) {
                    Responses.send((HttpResponse)Responses.response(HttpResponseStatus.NOT_MODIFIED), channel, request);
                    return true;
                }
            }
            catch (ParseException ignored) {
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendFile(@NotNull HttpRequest request, @NotNull Channel channel, @NotNull File file) throws IOException {
        RandomAccessFile raf;
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/FileResponses", "sendFile"));
        }
        if (channel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "channel", "org/jetbrains/io/FileResponses", "sendFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/io/FileResponses", "sendFile"));
        }
        if (FileResponses.checkCache(request, channel, file.lastModified())) {
            return;
        }
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        response.headers().add("Content-Type", (Object)FileResponses.getContentType(file.getPath()));
        Responses.addCommonHeaders((HttpResponse)response);
        response.headers().set("Cache-Control", (Object)"private, must-revalidate");
        response.headers().set("Last-Modified", (Object)Responses.DATE_FORMAT.get().format(new Date(file.lastModified())));
        boolean keepAlive = Responses.addKeepAliveIfNeed((HttpResponse)response, request);
        boolean fileWillBeClosed = false;
        try {
            raf = new RandomAccessFile(file, "r");
        }
        catch (FileNotFoundException ignored) {
            Responses.send((HttpResponse)Responses.response(HttpResponseStatus.NOT_FOUND), channel, request);
            return;
        }
        try {
            long fileLength = raf.length();
            if (request.method() != HttpMethod.HEAD) {
                HttpHeaders.setContentLength((HttpMessage)response, (long)fileLength);
            }
            channel.write((Object)response);
            if (request.method() != HttpMethod.HEAD) {
                if (channel.pipeline().get(SslHandler.class) == null) {
                    channel.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
                } else {
                    channel.write((Object)new ChunkedFile(raf));
                }
            }
            fileWillBeClosed = true;
        }
        finally {
            if (!fileWillBeClosed) {
                raf.close();
            }
        }
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

