/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public final class PooledThreadExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.ide.PooledThreadExecutor");
    private static final AtomicInteger myAliveThreads = new AtomicInteger();
    private static final AtomicInteger seq = new AtomicInteger();
    private static final int ourReasonableThreadPoolSize = Registry.intValue((String)"core.pooled.threads");
    private static final ExecutorService ourThreadExecutorsService;
    public static final ExecutorService INSTANCE;

    private PooledThreadExecutor() {
    }

    static {
        INSTANCE = ourThreadExecutorsService = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

            @Override
            @NotNull
            public Thread newThread(@NotNull Runnable r) {
                if (r == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/ide/PooledThreadExecutor$1", "newThread"));
                }
                int count = myAliveThreads.incrementAndGet();
                Thread thread = new Thread(r, "ApplicationImpl pooled thread " + seq.incrementAndGet()){

                    @Override
                    public void interrupt() {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Interrupted worker, will remove from pool");
                        }
                        super.interrupt();
                    }

                    @Override
                    public void run() {
                        block2: {
                            try {
                                super.run();
                            }
                            catch (Throwable t) {
                                if (!LOG.isDebugEnabled()) break block2;
                                LOG.debug("Worker exits due to exception", t);
                            }
                        }
                        myAliveThreads.decrementAndGet();
                    }
                };
                if (ApplicationInfoImpl.getShadowInstance().isEAP() && count > ourReasonableThreadPoolSize) {
                    LOG.info("Not enough pooled threads; dumping threads into a file");
                    PerformanceWatcher.getInstance().dumpThreads(true);
                }
                thread.setPriority(4);
                Thread thread2 = thread;
                if (thread2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/PooledThreadExecutor$1", "newThread"));
                }
                return thread2;
            }
        });
    }
}

