/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.SourceInfo;

public abstract class StackFrameImplBase
extends XStackFrame {
    protected final SourceInfo sourceInfo;
    protected XDebuggerEvaluator evaluator;

    public StackFrameImplBase(@Nullable SourceInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public final XDebuggerEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = this.createEvaluator();
        }
        return this.evaluator;
    }

    protected abstract XDebuggerEvaluator createEvaluator();

    @Nullable
    public SourceInfo getSourcePosition() {
        return this.sourceInfo;
    }

    protected boolean isInFileScope() {
        return false;
    }

    protected boolean isInLibraryContent() {
        return false;
    }

    public final void customizePresentation(@NotNull ColoredTextContainer component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "org/jetbrains/debugger/frame/StackFrameImplBase", "customizePresentation"));
        }
        if (this.sourceInfo == null) {
            this.customizeInvalidFramePresentation(component);
            return;
        }
        String fileName = this.sourceInfo.getFile().getName();
        int line = this.sourceInfo.getLine() + 1;
        boolean isInLibraryContent = this.isInLibraryContent();
        SimpleTextAttributes textAttributes = isInLibraryContent ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES;
        String functionName = this.sourceInfo.getFunctionName();
        if (functionName == null || functionName.isEmpty() && this.isInFileScope()) {
            component.append(fileName + ":" + line, textAttributes);
        } else {
            if (functionName.isEmpty()) {
                component.append("anonymous", isInLibraryContent ? SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            } else {
                component.append(functionName, textAttributes);
            }
            component.append("(), " + fileName + ":" + line, textAttributes);
        }
        component.setIcon(AllIcons.Debugger.StackFrame);
    }

    protected void customizeInvalidFramePresentation(ColoredTextContainer component) {
        super.customizePresentation(component);
    }
}

