/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.Consumer;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateContextAdditionalParameter;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.io.JsonUtil;

public final class ValueModifierUtil {
    private static final Pattern KEY_NOTATION_PROPERTY_NAME_PATTERN = Pattern.compile("[\\p{L}_$]+[\\d\\p{L}_$]*");

    public static ActionCallback setValue(final @NotNull Variable variable, String newValue, final @NotNull EvaluateContext evaluateContext, final @NotNull ValueModifier modifier) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        final ActionCallback callback = new ActionCallback();
        evaluateContext.evaluate(newValue).doWhenDone((Consumer)new Consumer<Value>(){

            public void consume(Value value) {
                modifier.setValue(variable, value, evaluateContext).notify(callback);
            }
        }).notifyWhenRejected(callback);
        return callback;
    }

    @NotNull
    public static AsyncResult<Value> evaluateGet(final @NotNull Variable variable, @NotNull EvaluateContextAdditionalParameter host, @NotNull EvaluateContext evaluateContext, @NotNull String selfName) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (selfName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selfName", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        StringBuilder builder = new StringBuilder(selfName);
        ValueModifierUtil.appendName(builder, variable.getName(), false);
        AsyncResult asyncResult = evaluateContext.evaluate(builder.toString(), Collections.singletonMap(selfName, host)).doWhenDone((Consumer)new Consumer<Value>(){

            public void consume(Value value) {
                variable.setValue(value);
            }
        });
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        return asyncResult;
    }

    public static String propertyNamesToString(List<String> list, boolean quotedAware) {
        StringBuilder builder = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            String name = list.get(i);
            boolean quoted = quotedAware && (name.charAt(0) == '\"' || name.charAt(0) == '\'');
            ValueModifierUtil.appendName(builder, name, quoted);
        }
        return builder.toString();
    }

    public static void appendName(@NotNull StringBuilder builder, @NotNull String name, boolean quoted) {
        boolean useKeyNotation;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/debugger/ValueModifierUtil", "appendName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/ValueModifierUtil", "appendName"));
        }
        boolean bl = useKeyNotation = !quoted && KEY_NOTATION_PROPERTY_NAME_PATTERN.matcher(name).matches();
        if (builder.length() != 0) {
            builder.append(useKeyNotation ? (char)'.' : '[');
        }
        if (useKeyNotation) {
            builder.append(name);
        } else {
            if (quoted) {
                builder.append(name);
            } else {
                JsonUtil.escape(name, builder);
            }
            builder.append(']');
        }
    }
}

