/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.SourceInfo;

public final class PsiVisitors {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <RESULT> RESULT visit(@NotNull XSourcePosition position, @NotNull Project project, @NotNull Visitor<RESULT> visitor, RESULT defaultResult) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "org/jetbrains/debugger/PsiVisitors", "visit"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/debugger/PsiVisitors", "visit"));
        }
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "org/jetbrains/debugger/PsiVisitors", "visit"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        AccessToken token = ReadAction.start();
        try {
            int positionOffset;
            PsiFile file;
            PsiFile psiFile = file = document == null || document.getTextLength() == 0 ? null : PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
            if (file == null) {
                RESULT RESULT = defaultResult;
                return RESULT;
            }
            int column = position instanceof SourceInfo ? Math.max(((SourceInfo)position).getColumn(), 0) : 0;
            try {
                positionOffset = column == 0 ? DocumentUtil.getFirstNonSpaceCharOffset(document, position.getLine()) : document.getLineStartOffset(position.getLine()) + column;
            }
            catch (IndexOutOfBoundsException ignored) {
                RESULT RESULT = defaultResult;
                token.finish();
                return RESULT;
            }
            PsiElement element = file.findElementAt(positionOffset);
            RESULT RESULT = element == null ? defaultResult : visitor.visit(element, positionOffset, document);
            return RESULT;
        }
        finally {
            token.finish();
        }
    }

    public static abstract class FilteringPsiRecursiveElementWalkingVisitor
    extends PsiRecursiveElementWalkingVisitor {
        public void visitElement(PsiElement element) {
            if (!(element instanceof ForeignLeafPsiElement) && element.isPhysical()) {
                super.visitElement(element);
            }
        }

        public void visitWhiteSpace(PsiWhiteSpace space) {
        }

        public void visitComment(PsiComment comment) {
        }

        public void visitOuterLanguageElement(OuterLanguageElement element) {
        }
    }

    public static abstract class Visitor<RESULT> {
        public abstract RESULT visit(@NotNull PsiElement var1, int var2, @NotNull Document var3);
    }
}

