/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ConcurrentHashMap;
import com.intellij.util.containers.ConcurrentHashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.EventListener;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointBase;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;

public abstract class BreakpointManagerBase<T extends BreakpointBase<?>>
implements BreakpointManager {
    protected final Set<T> breakpoints = new ConcurrentHashSet();
    protected final ConcurrentHashMap<T, T> breakpointDuplicationByTarget = new ConcurrentHashMap(new TObjectHashingStrategy<T>(){

        public int computeHashCode(T b) {
            int result = ((BreakpointBase)b).getLine();
            result = 31 * result + ((BreakpointBase)b).getColumn();
            if (((BreakpointBase)b).getCondition() != null) {
                result = 31 * result + ((BreakpointBase)b).getCondition().hashCode();
            }
            result = 31 * result + ((BreakpointBase)b).getTarget().hashCode();
            return result;
        }

        public boolean equals(T b1, T b2) {
            return ((BreakpointBase)b1).getTarget().getClass() == ((BreakpointBase)b2).getTarget().getClass() && ((BreakpointBase)b1).getTarget().equals(((BreakpointBase)b2).getTarget()) && ((BreakpointBase)b1).getLine() == ((BreakpointBase)b2).getLine() && ((BreakpointBase)b1).getColumn() == ((BreakpointBase)b2).getColumn() && StringUtil.equals((CharSequence)((BreakpointBase)b1).getCondition(), (CharSequence)((BreakpointBase)b2).getCondition());
        }
    });
    protected final EventDispatcher<BreakpointManager.BreakpointListener> dispatcher = EventDispatcher.create(BreakpointManager.BreakpointListener.class);

    protected abstract T createBreakpoint(@NotNull BreakpointTarget var1, int var2, int var3, @Nullable String var4, int var5, boolean var6);

    protected abstract AsyncResult<Breakpoint> doSetBreakpoint(BreakpointTarget var1, T var2);

    @Override
    public Breakpoint setBreakpoint(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, int ignoreCount, boolean enabled) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/debugger/BreakpointManagerBase", "setBreakpoint"));
        }
        final T breakpoint = this.createBreakpoint(target, line, column, condition, ignoreCount, enabled);
        BreakpointBase existingBreakpoint = (BreakpointBase)this.breakpointDuplicationByTarget.putIfAbsent(breakpoint, breakpoint);
        if (existingBreakpoint != null) {
            return existingBreakpoint;
        }
        this.breakpoints.add(breakpoint);
        if (enabled) {
            this.doSetBreakpoint(target, breakpoint).doWhenRejected((Consumer)new Consumer<String>(){

                public void consume(@Nullable String errorMessage) {
                    ((BreakpointManager.BreakpointListener)BreakpointManagerBase.this.dispatcher.getMulticaster()).errorOccurred(breakpoint, errorMessage);
                }
            });
        }
        return breakpoint;
    }

    @Override
    public ActionCallback remove(@NotNull Breakpoint breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/BreakpointManagerBase", "remove"));
        }
        BreakpointBase b = (BreakpointBase)breakpoint;
        boolean existed = this.breakpoints.remove(b);
        if (existed) {
            this.breakpointDuplicationByTarget.remove((Object)b);
        }
        return !existed || !b.isVmRegistered() ? ActionCallback.DONE : this.doClearBreakpoint(b);
    }

    @Override
    @NotNull
    public ActionCallback removeAll() {
        BreakpointBase[] list = this.breakpoints.toArray(new BreakpointBase[this.breakpoints.size()]);
        this.breakpoints.clear();
        this.breakpointDuplicationByTarget.clear();
        ActionCallback.Chunk chunk = new ActionCallback.Chunk();
        for (BreakpointBase b : list) {
            if (!b.isVmRegistered()) continue;
            chunk.add(this.doClearBreakpoint(b));
        }
        ActionCallback actionCallback = chunk.create();
        if (actionCallback == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointManagerBase", "removeAll"));
        }
        return actionCallback;
    }

    protected abstract ActionCallback doClearBreakpoint(@NotNull T var1);

    @Override
    public void addBreakpointListener(@NotNull BreakpointManager.BreakpointListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "org/jetbrains/debugger/BreakpointManagerBase", "addBreakpointListener"));
        }
        this.dispatcher.addListener((EventListener)listener);
    }

    public Iterable<T> getBreakpoints() {
        return this.breakpoints;
    }

    protected final void notifyBreakpointResolvedListener(@NotNull T breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "org/jetbrains/debugger/BreakpointManagerBase", "notifyBreakpointResolvedListener"));
        }
        if (((BreakpointBase)breakpoint).isResolved()) {
            ((BreakpointManager.BreakpointListener)this.dispatcher.getMulticaster()).resolved((Breakpoint)breakpoint);
        }
    }
}

