/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointTarget;

public abstract class BreakpointBase<L>
extends Breakpoint {
    protected int line;
    protected final int column;
    protected boolean enabled;
    protected String condition;
    protected final BreakpointTarget target;
    protected final List<L> actualLocations;
    protected volatile boolean dirty;

    protected BreakpointBase(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, boolean enabled) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/debugger/BreakpointBase", "<init>"));
        }
        this.actualLocations = ContainerUtil.createLockFreeCopyOnWriteList();
        this.target = target;
        this.line = line;
        this.column = column;
        this.condition = condition;
        this.enabled = enabled;
    }

    @Override
    public boolean isResolved() {
        return !this.actualLocations.isEmpty();
    }

    @Override
    @NotNull
    public BreakpointTarget getTarget() {
        BreakpointTarget breakpointTarget = this.target;
        if (breakpointTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/BreakpointBase", "getTarget"));
        }
        return breakpointTarget;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Override
    @Nullable
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(@Nullable String condition) {
        if (StringUtil.equals((CharSequence)this.condition, (CharSequence)condition)) {
            return;
        }
        this.condition = condition;
        this.dirty = true;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Breakpoint enabled(boolean value) {
        if (value == this.enabled) {
            return this;
        }
        this.enabled = value;
        this.dirty = true;
        return this;
    }

    public List<L> getActualLocations() {
        return this.actualLocations;
    }

    public void setActualLocations(@Nullable List<L> value) {
        this.actualLocations.clear();
        if (value != null && !value.isEmpty()) {
            this.actualLocations.addAll(value);
        }
    }

    public abstract boolean isVmRegistered();

    public int hashCode() {
        int result = this.line;
        result = 31 * result + this.column;
        result = 31 * result + (this.enabled ? 1 : 0);
        if (this.condition != null) {
            result = 31 * result + this.condition.hashCode();
        }
        result = 31 * result + this.target.hashCode();
        return result;
    }
}

