/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathInfo {
    private final VirtualFile child;
    private final VirtualFile root;
    String moduleName;
    private String computedPath;

    public PathInfo(@NotNull VirtualFile child, @NotNull VirtualFile root, @Nullable String moduleName) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/builtInWebServer/PathInfo", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/builtInWebServer/PathInfo", "<init>"));
        }
        this.child = child;
        this.root = root;
        this.moduleName = moduleName;
    }

    public PathInfo(@NotNull VirtualFile child, @NotNull VirtualFile root) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/builtInWebServer/PathInfo", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/builtInWebServer/PathInfo", "<init>"));
        }
        this(child, root, null);
    }

    @NotNull
    public VirtualFile getChild() {
        VirtualFile virtualFile = this.child;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/PathInfo", "getChild"));
        }
        return virtualFile;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.root;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/PathInfo", "getRoot"));
        }
        return virtualFile;
    }

    @Nullable
    public String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public String getPath() {
        if (this.computedPath == null) {
            this.computedPath = (this.moduleName == null ? "" : this.moduleName + '/') + VfsUtilCore.getRelativePath((VirtualFile)this.child, (VirtualFile)this.root, (char)'/');
        }
        String string = this.computedPath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/PathInfo", "getPath"));
        }
        return string;
    }
}

