/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PairFunction;
import com.intellij.util.PlatformUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServer;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.builtInWebServer.WebServerRootsProvider;

final class DefaultWebServerRootsProvider
extends WebServerRootsProvider {
    DefaultWebServerRootsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PathInfo resolve(@NotNull String path, @NotNull Project project) {
        Module[] modules;
        PairFunction<String, VirtualFile, VirtualFile> resolver;
        int index;
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        if (PlatformUtils.isIntelliJ() && (index = path.indexOf(47)) > 0 && !path.regionMatches(!SystemInfo.isFileSystemCaseSensitive, 0, project.getName(), 0, index)) {
            Module module;
            String moduleName = path.substring(0, index);
            AccessToken token = ReadAction.start();
            try {
                module = ModuleManager.getInstance((Project)project).findModuleByName(moduleName);
            }
            finally {
                token.finish();
            }
            if (module != null && !module.isDisposed()) {
                path = path.substring(index + 1);
                resolver = WebServerPathToFileManager.getInstance(project).getResolver(path);
                ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
                PathInfo result = DefaultWebServerRootsProvider.resolve(path, moduleRootManager.getSourceRoots(), resolver, moduleName);
                if (result == null) {
                    result = DefaultWebServerRootsProvider.resolve(path, moduleRootManager.getContentRoots(), resolver, moduleName);
                }
                if (result != null) {
                    return result;
                }
            }
        }
        AccessToken token = ReadAction.start();
        try {
            modules = ModuleManager.getInstance((Project)project).getModules();
        }
        finally {
            token.finish();
        }
        resolver = WebServerPathToFileManager.getInstance(project).getResolver(path);
        PathInfo result = DefaultWebServerRootsProvider.findByRelativePath(project, path, modules, true, resolver);
        if (result == null) {
            return DefaultWebServerRootsProvider.findByRelativePath(project, path, modules, false, resolver);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public PathInfo getRoot(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getRoot"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getRoot"));
        }
        AccessToken token = ReadAction.start();
        try {
            VirtualFile root;
            VirtualFile notExcludedParent;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            for (notExcludedParent = file; notExcludedParent != null && fileIndex.isExcluded(notExcludedParent); notExcludedParent = notExcludedParent.getParent()) {
            }
            if (notExcludedParent == null) {
                PathInfo pathInfo = null;
                return pathInfo;
            }
            if (fileIndex.isInSourceContent(notExcludedParent)) {
                root = fileIndex.getSourceRootForFile(notExcludedParent);
            } else if (fileIndex.isInContent(notExcludedParent)) {
                root = fileIndex.getContentRootForFile(notExcludedParent);
            } else if (fileIndex.isInLibraryClasses(notExcludedParent)) {
                root = fileIndex.getClassRootForFile(notExcludedParent);
            } else {
                PathInfo pathInfo = null;
                return pathInfo;
            }
            assert (root != null) : file.getPresentableUrl();
            PathInfo pathInfo = new PathInfo(file, root, DefaultWebServerRootsProvider.getModuleNameQualifier(project, fileIndex.getModuleForFile(notExcludedParent)));
            return pathInfo;
        }
        finally {
            token.finish();
        }
    }

    @Nullable
    private static String getModuleNameQualifier(@NotNull Project project, @Nullable Module module) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "getModuleNameQualifier"));
        }
        if (module != null && PlatformUtils.isIntelliJ() && !module.getName().equalsIgnoreCase(project.getName()) && !BuiltInWebServer.compareNameAndProjectBasePath(module.getName(), project)) {
            return module.getName();
        }
        return null;
    }

    @Nullable
    private static PathInfo resolve(@NotNull String path, @NotNull VirtualFile[] roots, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver, @Nullable String moduleName) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "resolve"));
        }
        for (VirtualFile root : roots) {
            VirtualFile file = (VirtualFile)resolver.fun((Object)path, (Object)root);
            if (file == null) continue;
            return new PathInfo(file, root, moduleName);
        }
        return null;
    }

    @Nullable
    private static PathInfo findByRelativePath(@NotNull Project project, @NotNull String path, @NotNull Module[] modules, boolean inSourceRoot, @NotNull PairFunction<String, VirtualFile, VirtualFile> resolver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "org/jetbrains/builtInWebServer/DefaultWebServerRootsProvider", "findByRelativePath"));
        }
        for (Module module : modules) {
            if (module.isDisposed()) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            PathInfo result = DefaultWebServerRootsProvider.resolve(path, inSourceRoot ? moduleRootManager.getSourceRoots() : moduleRootManager.getContentRoots(), resolver, null);
            if (result == null) continue;
            result.moduleName = DefaultWebServerRootsProvider.getModuleNameQualifier(project, module);
            return result;
        }
        return null;
    }
}

