/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SimpleConfigurable;
import com.intellij.openapi.util.Getter;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerConfigurableUi;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.CustomPortServerManager;
import org.jetbrains.io.CustomPortServerManagerBase;

@State(name="BuiltInServerOptions", storages={@Storage(file="$APP_CONFIG$/other.xml")})
public class BuiltInServerOptions
implements PersistentStateComponent<BuiltInServerOptions>,
ExportableComponent,
Getter<BuiltInServerOptions> {
    @Attribute
    public int builtInServerPort = 63342;
    @Attribute
    public boolean builtInServerAvailableExternally = false;

    public static BuiltInServerOptions getInstance() {
        return (BuiltInServerOptions)ServiceManager.getService(BuiltInServerOptions.class);
    }

    public BuiltInServerOptions get() {
        return this;
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)"other")};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInServerOptions", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("Built-in server" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInServerOptions", "getPresentableName"));
        }
        return "Built-in server";
    }

    @Nullable
    public BuiltInServerOptions getState() {
        return this;
    }

    public void loadState(BuiltInServerOptions state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public int getEffectiveBuiltInServerPort() {
        MyCustomPortServerManager portServerManager = (MyCustomPortServerManager)((Object)CustomPortServerManager.EP_NAME.findExtension(MyCustomPortServerManager.class));
        if (!portServerManager.isBound()) {
            return BuiltInServerManager.getInstance().getPort();
        }
        return this.builtInServerPort;
    }

    public static void onBuiltInServerPortChanged() {
        ((MyCustomPortServerManager)((Object)CustomPortServerManager.EP_NAME.findExtension(MyCustomPortServerManager.class))).portChanged();
    }

    public static final class MyCustomPortServerManager
    extends CustomPortServerManagerBase {
        public void cannotBind(Exception e, int port) {
            String groupDisplayId = "Built-in Web Server";
            Notifications.Bus.register((String)groupDisplayId, (NotificationDisplayType)NotificationDisplayType.STICKY_BALLOON);
            new Notification(groupDisplayId, "Built-in HTTP server on custom port " + port + " disabled", "Cannot start built-in HTTP server on custom port " + port + ". " + "Please ensure that port is free (or check your firewall settings) and restart " + ApplicationNamesInfo.getInstance().getFullProductName(), NotificationType.ERROR).notify(null);
        }

        public int getPort() {
            return BuiltInServerOptions.getInstance().builtInServerPort;
        }

        public boolean isAvailableExternally() {
            return BuiltInServerOptions.getInstance().builtInServerAvailableExternally;
        }
    }

    static final class BuiltInServerDebuggerConfigurableProvider
    extends DebuggerConfigurableProvider {
        BuiltInServerDebuggerConfigurableProvider() {
        }

        @NotNull
        public Collection<? extends Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
            if (category == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "category", "org/jetbrains/builtInWebServer/BuiltInServerOptions$BuiltInServerDebuggerConfigurableProvider", "getConfigurables"));
            }
            if (category == DebuggerSettingsCategory.GENERAL) {
                List<SimpleConfigurable> list = Collections.singletonList(SimpleConfigurable.create((String)"builtInServer", (String)"", BuiltInServerConfigurableUi.class, (Getter)BuiltInServerOptions.getInstance()));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInServerOptions$BuiltInServerDebuggerConfigurableProvider", "getConfigurables"));
                }
                return list;
            }
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/BuiltInServerOptions$BuiltInServerDebuggerConfigurableProvider", "getConfigurables"));
            }
            return list;
        }
    }
}

