/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.intention;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpModifierProvider;
import org.jetbrains.annotations.NotNull;

public class CheckRegExpForm {
    private static final String LAST_EDITED_REGEXP = "last.edited.regexp";
    private final PsiFile myRegexpFile;
    private EditorTextField mySampleText;
    private EditorTextField myRegExp;
    private JPanel myRootPanel;
    private JBLabel myMessage;
    private Project myProject;

    public CheckRegExpForm(@NotNull PsiFile regexpFile) {
        if (regexpFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regexpFile", "org/intellij/lang/regexp/intention/CheckRegExpForm", "<init>"));
        }
        this.myRegexpFile = regexpFile;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.myProject = this.myRegexpFile.getProject();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(this.myRegexpFile);
        this.myRegExp = new EditorTextField(document, this.myProject, (FileType)RegExpLanguage.INSTANCE.getAssociatedFileType());
        this.myRegExp.setPreferredWidth(Math.max(300, this.myRegExp.getPreferredSize().width));
        String sampleText = PropertiesComponent.getInstance((Project)this.myProject).getValue(LAST_EDITED_REGEXP, "Sample Text");
        this.mySampleText = new EditorTextField(sampleText, this.myProject, (FileType)PlainTextFileType.INSTANCE);
        this.mySampleText.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 4), new LineBorder((Color)(UIUtil.isUnderDarcula() ? Gray._100 : JBColor.border()))));
        this.mySampleText.setOneLineMode(false);
        this.myRootPanel = new JPanel(new BorderLayout()){
            Disposable disposable;

            @Override
            public void addNotify() {
                super.addNotify();
                this.disposable = Disposer.newDisposable();
                IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)CheckRegExpForm.this.mySampleText), true);
                new AnAction(){

                    public void actionPerformed(AnActionEvent e) {
                        IdeFocusManager.findInstance().requestFocus((Component)CheckRegExpForm.this.myRegExp.getFocusTarget(), true);
                    }
                }.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])new String[]{"shift TAB"}), (JComponent)((Object)CheckRegExpForm.this.mySampleText));
                final Alarm updater = new Alarm(Alarm.ThreadToUse.SWING_THREAD, this.disposable);
                DocumentAdapter documentListener = new DocumentAdapter(){

                    public void documentChanged(DocumentEvent e) {
                        updater.cancelAllRequests();
                        if (!updater.isDisposed()) {
                            updater.addRequest(new Runnable(){

                                @Override
                                public void run() {
                                    CheckRegExpForm.this.updateBalloon();
                                }
                            }, 200);
                        }
                    }
                };
                CheckRegExpForm.this.myRegExp.addDocumentListener((DocumentListener)documentListener);
                CheckRegExpForm.this.mySampleText.addDocumentListener((DocumentListener)documentListener);
                CheckRegExpForm.this.updateBalloon();
                CheckRegExpForm.this.mySampleText.selectAll();
            }

            @Override
            public void removeNotify() {
                super.removeNotify();
                Disposer.dispose((Disposable)this.disposable);
                PropertiesComponent.getInstance((Project)CheckRegExpForm.this.myProject).setValue(CheckRegExpForm.LAST_EDITED_REGEXP, CheckRegExpForm.this.mySampleText.getText());
            }
        };
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        EditorTextField editorTextField = this.mySampleText;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpForm", "getPreferredFocusedComponent"));
        }
        return editorTextField;
    }

    @NotNull
    public JPanel getRootPanel() {
        JPanel jPanel = this.myRootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/intention/CheckRegExpForm", "getRootPanel"));
        }
        return jPanel;
    }

    private void updateBalloon() {
        boolean correct = false;
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)this.myRegexpFile);
        int flags = 0;
        if (host != null) {
            RegExpModifierProvider provider;
            RegExpModifierProvider[] arr$ = (RegExpModifierProvider[])RegExpModifierProvider.EP.getExtensions();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (flags = (provider = arr$[i$]).getFlags((PsiElement)host, this.myRegexpFile)) <= 0; ++i$) {
            }
        }
        try {
            correct = Pattern.compile(this.myRegExp.getText(), flags).matcher(this.mySampleText.getText()).matches();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        JBColor color1 = new JBColor(new Color(231, 250, 219), new Color(68, 85, 66));
        JBColor color2 = new JBColor(new Color(255, 177, 160), new Color(110, 43, 40));
        this.mySampleText.setBackground((Color)(correct ? color1 : color2));
        this.myMessage.setText(correct ? "Matches!" : "no match");
        this.myRootPanel.revalidate();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        this.createUIComponents();
        JPanel jPanel = this.myRootPanel;
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel3, "Center");
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 10, 5), null, 0, 0, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel4, "North");
        EditorTextField editorTextField = this.myRegExp;
        jPanel4.add((Component)((Object)editorTextField), "Center");
        JLabel jLabel = new JLabel();
        jLabel.setText("RegExp:");
        jLabel.setAlignmentX(1.0f);
        jLabel.setPreferredSize(new Dimension(55, 16));
        jPanel4.add((Component)jLabel, "West");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel5, "Center");
        EditorTextField editorTextField2 = this.mySampleText;
        jPanel5.add((Component)((Object)editorTextField2), "Center");
        JLabel jLabel2 = new JLabel();
        jLabel2.setAlignmentY(0.0f);
        jLabel2.setText("Sample:");
        jLabel2.setAlignmentX(1.0f);
        jLabel2.setPreferredSize(new Dimension(55, 16));
        jPanel5.add((Component)jLabel2, "West");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel6, "South");
        this.myMessage = jBLabel = new JBLabel();
        jBLabel.setAlignmentX(0.5f);
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setText("Red means I can't hear you!");
        jPanel6.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel6.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

