/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.EnumSet;
import org.intellij.lang.regexp.RegExpCapability;
import org.intellij.lang.regexp.RegExpElementTypes;
import org.intellij.lang.regexp.RegExpFile;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.lang.regexp.RegExpLexer;
import org.intellij.lang.regexp.RegExpParser;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.impl.RegExpBackrefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBoundaryImpl;
import org.intellij.lang.regexp.psi.impl.RegExpBranchImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharImpl;
import org.intellij.lang.regexp.psi.impl.RegExpCharRangeImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClassImpl;
import org.intellij.lang.regexp.psi.impl.RegExpClosureImpl;
import org.intellij.lang.regexp.psi.impl.RegExpGroupImpl;
import org.intellij.lang.regexp.psi.impl.RegExpIntersectionImpl;
import org.intellij.lang.regexp.psi.impl.RegExpOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPatternImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPropertyImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPyCondRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpPyNamedGroupRefImpl;
import org.intellij.lang.regexp.psi.impl.RegExpQuantifierImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSetOptionsImpl;
import org.intellij.lang.regexp.psi.impl.RegExpSimpleClassImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpParserDefinition
implements ParserDefinition {
    private static final TokenSet COMMENT_TOKENS = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.COMMENT});

    @NotNull
    public Lexer createLexer(Project project) {
        RegExpLexer regExpLexer = new RegExpLexer(EnumSet.of(RegExpCapability.NESTED_CHARACTER_CLASSES));
        if (regExpLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createLexer"));
        }
        return regExpLexer;
    }

    public PsiParser createParser(Project project) {
        return new RegExpParser();
    }

    public IFileElementType getFileNodeType() {
        return RegExpElementTypes.REGEXP_FILE;
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{RegExpTT.QUOTE_BEGIN, RegExpTT.QUOTE_END, TokenType.WHITE_SPACE});
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "getWhitespaceTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "getStringLiteralElements"));
        }
        return tokenSet;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        TokenSet tokenSet = COMMENT_TOKENS;
        if (tokenSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "getCommentTokens"));
        }
        return tokenSet;
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        IElementType type = node.getElementType();
        if (type == RegExpElementTypes.PATTERN) {
            RegExpPatternImpl regExpPatternImpl = new RegExpPatternImpl(node);
            if (regExpPatternImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPatternImpl;
        }
        if (type == RegExpElementTypes.BRANCH) {
            RegExpBranchImpl regExpBranchImpl = new RegExpBranchImpl(node);
            if (regExpBranchImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpBranchImpl;
        }
        if (type == RegExpElementTypes.SIMPLE_CLASS) {
            RegExpSimpleClassImpl regExpSimpleClassImpl = new RegExpSimpleClassImpl(node);
            if (regExpSimpleClassImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpSimpleClassImpl;
        }
        if (type == RegExpElementTypes.CLASS) {
            RegExpClassImpl regExpClassImpl = new RegExpClassImpl(node);
            if (regExpClassImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpClassImpl;
        }
        if (type == RegExpElementTypes.CHAR_RANGE) {
            RegExpCharRangeImpl regExpCharRangeImpl = new RegExpCharRangeImpl(node);
            if (regExpCharRangeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpCharRangeImpl;
        }
        if (type == RegExpElementTypes.CHAR) {
            RegExpCharImpl regExpCharImpl = new RegExpCharImpl(node);
            if (regExpCharImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpCharImpl;
        }
        if (type == RegExpElementTypes.GROUP) {
            RegExpGroupImpl regExpGroupImpl = new RegExpGroupImpl(node);
            if (regExpGroupImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpGroupImpl;
        }
        if (type == RegExpElementTypes.PROPERTY) {
            RegExpPropertyImpl regExpPropertyImpl = new RegExpPropertyImpl(node);
            if (regExpPropertyImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPropertyImpl;
        }
        if (type == RegExpElementTypes.SET_OPTIONS) {
            RegExpSetOptionsImpl regExpSetOptionsImpl = new RegExpSetOptionsImpl(node);
            if (regExpSetOptionsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpSetOptionsImpl;
        }
        if (type == RegExpElementTypes.OPTIONS) {
            RegExpOptionsImpl regExpOptionsImpl = new RegExpOptionsImpl(node);
            if (regExpOptionsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpOptionsImpl;
        }
        if (type == RegExpElementTypes.BACKREF) {
            RegExpBackrefImpl regExpBackrefImpl = new RegExpBackrefImpl(node);
            if (regExpBackrefImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpBackrefImpl;
        }
        if (type == RegExpElementTypes.CLOSURE) {
            RegExpClosureImpl regExpClosureImpl = new RegExpClosureImpl(node);
            if (regExpClosureImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpClosureImpl;
        }
        if (type == RegExpElementTypes.QUANTIFIER) {
            RegExpQuantifierImpl regExpQuantifierImpl = new RegExpQuantifierImpl(node);
            if (regExpQuantifierImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpQuantifierImpl;
        }
        if (type == RegExpElementTypes.BOUNDARY) {
            RegExpBoundaryImpl regExpBoundaryImpl = new RegExpBoundaryImpl(node);
            if (regExpBoundaryImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpBoundaryImpl;
        }
        if (type == RegExpElementTypes.INTERSECTION) {
            RegExpIntersectionImpl regExpIntersectionImpl = new RegExpIntersectionImpl(node);
            if (regExpIntersectionImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpIntersectionImpl;
        }
        if (type == RegExpElementTypes.PY_NAMED_GROUP_REF) {
            RegExpPyNamedGroupRefImpl regExpPyNamedGroupRefImpl = new RegExpPyNamedGroupRefImpl(node);
            if (regExpPyNamedGroupRefImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPyNamedGroupRefImpl;
        }
        if (type == RegExpElementTypes.PY_COND_REF) {
            RegExpPyCondRefImpl regExpPyCondRefImpl = new RegExpPyCondRefImpl(node);
            if (regExpPyCondRefImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
            }
            return regExpPyCondRefImpl;
        }
        ASTWrapperPsiElement aSTWrapperPsiElement = new ASTWrapperPsiElement(node);
        if (aSTWrapperPsiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/RegExpParserDefinition", "createElement"));
        }
        return aSTWrapperPsiElement;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new RegExpFile(viewProvider, RegExpLanguage.INSTANCE);
    }

    public ParserDefinition.SpaceRequirements spaceExistanceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MUST_NOT;
    }
}

