/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.vp;

import com.google.common.base.Preconditions;
import com.jetbrains.python.vp.Creator;
import com.jetbrains.python.vp.Presenter;
import com.jetbrains.python.vp.PresenterHandler;
import com.jetbrains.python.vp.ViewHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.jetbrains.annotations.NotNull;

public final class ViewPresenterUtils {
    private ViewPresenterUtils() {
    }

    public static <V, P extends Presenter> void linkViewWithPresenterAndLaunch(@NotNull Class<P> presenterInterface, @NotNull Class<V> viewInterface, @NotNull Creator<V, P> creator) {
        if (presenterInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presenterInterface", "com/jetbrains/python/vp/ViewPresenterUtils", "linkViewWithPresenterAndLaunch"));
        }
        if (viewInterface == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "viewInterface", "com/jetbrains/python/vp/ViewPresenterUtils", "linkViewWithPresenterAndLaunch"));
        }
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/jetbrains/python/vp/ViewPresenterUtils", "linkViewWithPresenterAndLaunch"));
        }
        Preconditions.checkArgument((boolean)presenterInterface.isInterface(), (Object)"Presenter is not interface");
        Preconditions.checkArgument((boolean)viewInterface.isInterface(), (Object)"View is not interface");
        PresenterHandler<P> presenterHandler = new PresenterHandler<P>();
        ViewHandler<V> viewHandler = new ViewHandler<V>();
        V viewProxy = ViewPresenterUtils.createProxy(viewInterface, viewHandler);
        Presenter presenterProxy = (Presenter)ViewPresenterUtils.createProxy(presenterInterface, presenterHandler);
        V realView = creator.createView(presenterProxy);
        viewHandler.setRealView(realView);
        P realPresenter = creator.createPresenter(viewProxy);
        presenterHandler.setRealPresenter(realPresenter);
        realPresenter.launch();
    }

    private static <C> C createProxy(Class<C> clazz, InvocationHandler handler) {
        assert (clazz != null);
        assert (handler != null);
        return (C)Proxy.newProxyInstance(ViewPresenterUtils.class.getClassLoader(), new Class[]{clazz}, handler);
    }
}

