/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.ComprhForComponent;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyExceptPart;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyListCompExpression;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyTupleExpression;
import java.io.CharArrayWriter;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class UnsupportedFeaturesUtil {
    public static Map<LanguageLevel, Set<String>> BUILTINS = new HashMap<LanguageLevel, Set<String>>();
    public static Map<LanguageLevel, Set<String>> MODULES = new HashMap<LanguageLevel, Set<String>>();
    public static Map<String, Map<LanguageLevel, Set<String>>> CLASS_METHODS = new HashMap<String, Map<LanguageLevel, Set<String>>>();
    public static Vector<String> ALL_LANGUAGE_LEVELS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillTestCaseMethods() throws IOException {
        Logger log = Logger.getInstance((String)UnsupportedFeaturesUtil.class.getName());
        FileReader reader = new FileReader(PythonHelpersLocator.getHelperPath("/tools/class_method_versions.xml"));
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            ClassMethodsParser parser = new ClassMethodsParser();
            xr.setContentHandler(parser);
            xr.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            log.error("Improperly formed \"class_method_versions.xml\". " + e.getMessage());
        }
        finally {
            reader.close();
        }
    }

    private static void fillAllLanguageLeves() {
        ALL_LANGUAGE_LEVELS = new Vector();
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON24.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON25.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON26.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON27.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON30.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON31.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON32.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON33.toString());
        ALL_LANGUAGE_LEVELS.add(LanguageLevel.PYTHON34.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void fillMaps() throws IOException {
        Logger log = Logger.getInstance((String)UnsupportedFeaturesUtil.class.getName());
        FileReader reader = new FileReader(PythonHelpersLocator.getHelperPath("/tools/versions.xml"));
        try {
            XMLReader xr = XMLReaderFactory.createXMLReader();
            VersionsParser parser = new VersionsParser();
            xr.setContentHandler(parser);
            xr.parse(new InputSource(reader));
        }
        catch (SAXException e) {
            log.error("Improperly formed \"versions.xml\". " + e.getMessage());
        }
        finally {
            reader.close();
        }
    }

    public static boolean raiseHasNoArgs(PyRaiseStatement node, LanguageLevel versionToProcess) {
        PyExceptPart exceptPart;
        PyExpression[] expressions = node.getExpressions();
        return expressions.length == 0 && versionToProcess.isPy3K() && (exceptPart = (PyExceptPart)PsiTreeUtil.getParentOfType((PsiElement)node, PyExceptPart.class)) == null;
    }

    public static boolean raiseHasMoreThenOneArg(PyRaiseStatement node, LanguageLevel versionToProcess) {
        PyExpression[] expressions = node.getExpressions();
        if (expressions.length > 0) {
            if (expressions.length < 2) {
                return false;
            }
            if (versionToProcess.isPy3K()) {
                if (expressions.length == 3) {
                    return true;
                }
                PsiElement element = expressions[0].getNextSibling();
                while (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element != null && ",".equals(element.getText())) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean raiseHasFromKeyword(PyRaiseStatement node, LanguageLevel versionToProcess) {
        PyExpression[] expressions = node.getExpressions();
        if (expressions.length > 0) {
            if (expressions.length < 2) {
                return false;
            }
            if (!versionToProcess.isPy3K()) {
                PsiElement element = expressions[0].getNextSibling();
                while (element instanceof PsiWhiteSpace) {
                    element = element.getNextSibling();
                }
                if (element != null && element.getNode().getElementType() == PyTokenTypes.FROM_KEYWORD) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean visitPyListCompExpression(PyListCompExpression node, LanguageLevel versionToProcess) {
        List<ComprhForComponent> forComponents = node.getForComponents();
        if (versionToProcess.isPy3K()) {
            for (ComprhForComponent forComponent : forComponents) {
                PyExpression iteratedList = forComponent.getIteratedList();
                if (!(iteratedList instanceof PyTupleExpression)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        try {
            UnsupportedFeaturesUtil.fillMaps();
            UnsupportedFeaturesUtil.fillTestCaseMethods();
        }
        catch (IOException e) {
            Logger log = Logger.getInstance((String)UnsupportedFeaturesUtil.class.getName());
            log.error("Cannot find \"versions.xml\". " + e.getMessage());
        }
        UnsupportedFeaturesUtil.fillAllLanguageLeves();
    }

    static class ClassMethodsParser
    extends DefaultHandler {
        private CharArrayWriter myContent = new CharArrayWriter();
        private String myClassName = "";
        private LanguageLevel myCurrentLevel;

        ClassMethodsParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
            this.myContent.reset();
            if (localName.equals("class_name")) {
                this.myClassName = attr.getValue("name");
                if (!CLASS_METHODS.containsKey(this.myClassName)) {
                    CLASS_METHODS.put(this.myClassName, new HashMap());
                }
            }
            if (localName.equals("python")) {
                Map<LanguageLevel, Set<String>> map;
                this.myCurrentLevel = LanguageLevel.fromPythonVersion(attr.getValue("version"));
                if (this.myClassName != null && (map = CLASS_METHODS.get(this.myClassName)) != null) {
                    map.put(this.myCurrentLevel, new HashSet());
                }
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            Set<String> set;
            Map<LanguageLevel, Set<String>> levelSetMap;
            if (localName.equals("func") && (levelSetMap = CLASS_METHODS.get(this.myClassName)) != null && (set = levelSetMap.get((Object)this.myCurrentLevel)) != null) {
                set.add(this.myContent.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.myContent.write(ch, start, length);
        }
    }

    private static class VersionsParser
    extends DefaultHandler {
        private CharArrayWriter myContent = new CharArrayWriter();
        private LanguageLevel myCurrentLevel;

        private VersionsParser() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attr) throws SAXException {
            this.myContent.reset();
            if (localName.equals("python")) {
                BUILTINS.put(LanguageLevel.fromPythonVersion(attr.getValue("version")), new HashSet());
                MODULES.put(LanguageLevel.fromPythonVersion(attr.getValue("version")), new HashSet());
                this.myCurrentLevel = LanguageLevel.fromPythonVersion(attr.getValue("version"));
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (localName.equals("func")) {
                BUILTINS.get((Object)this.myCurrentLevel).add(this.myContent.toString());
            }
            if (localName.equals("module")) {
                MODULES.get((Object)this.myCurrentLevel).add(this.myContent.toString());
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.myContent.write(ch, start, length);
        }
    }
}

