/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.codeInspection.ex.QuickFixWrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.validation.CompatibilityVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class UnsupportedFeatures
extends CompatibilityVisitor {
    public UnsupportedFeatures() {
        super(new ArrayList<LanguageLevel>());
    }

    @Override
    public void visitPyElement(PyElement node) {
        this.setVersionsToProcess(Arrays.asList(LanguageLevel.forElement((PsiElement)node)));
    }

    @Override
    protected void registerProblem(@Nullable PsiElement node, String message, LocalQuickFix localQuickFix, boolean asError) {
        if (node == null) {
            return;
        }
        this.registerProblem(node, node.getTextRange(), message, localQuickFix, asError);
    }

    @Override
    protected void registerProblem(PsiElement node, TextRange range, String message, LocalQuickFix localQuickFix, boolean asError) {
        if (range.isEmpty()) {
            return;
        }
        if (localQuickFix != null) {
            if (asError) {
                this.getHolder().createErrorAnnotation(range, message).registerFix(UnsupportedFeatures.createIntention(node, message, localQuickFix));
            } else {
                this.getHolder().createWarningAnnotation(range, message).registerFix(UnsupportedFeatures.createIntention(node, message, localQuickFix));
            }
        } else if (asError) {
            this.getHolder().createErrorAnnotation(range, message);
        } else {
            this.getHolder().createWarningAnnotation(range, message);
        }
    }

    private static IntentionAction createIntention(PsiElement node, String message, LocalQuickFix fix) {
        return UnsupportedFeatures.createIntention(node, node.getTextRange(), message, fix);
    }

    private static IntentionAction createIntention(PsiElement node, TextRange range, String message, LocalQuickFix fix) {
        LocalQuickFix[] quickFixes = new LocalQuickFix[]{fix};
        ProblemDescriptorImpl descr = new ProblemDescriptorImpl(node, node, message, quickFixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, range, true);
        return QuickFixWrapper.wrap(descr, 0);
    }
}

