/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.validation.PyAnnotator;

public class PyDefinitionsAnnotator
extends PyAnnotator {
    @Override
    public void visitPyClass(PyClass node) {
        ASTNode name_node = node.getNameNode();
        if (name_node != null) {
            Annotation ann = this.getHolder().createInfoAnnotation(name_node, null);
            ann.setTextAttributes(PyHighlighter.PY_CLASS_DEFINITION);
        }
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        ASTNode name_node = node.getNameNode();
        if (name_node != null) {
            Annotation ann = this.getHolder().createInfoAnnotation(name_node, null);
            String name = node.getName();
            LanguageLevel languageLevel = LanguageLevel.forElement(node);
            if (PyNames.UnderscoredAttributes.contains((Object)name) || PyNames.getBuiltinMethods(languageLevel).containsKey((Object)name)) {
                PyClass cls = node.getContainingClass();
                if ("__new__".equals(name)) {
                    boolean new_style_class = false;
                    try {
                        if (cls != null) {
                            new_style_class = cls.isNewStyleClass();
                        }
                    }
                    catch (IndexNotReadyException ignored) {
                        // empty catch block
                    }
                    if (new_style_class) {
                        ann.setTextAttributes(PyHighlighter.PY_PREDEFINED_DEFINITION);
                    }
                } else {
                    ann.setTextAttributes(PyHighlighter.PY_PREDEFINED_DEFINITION);
                }
            } else {
                ann.setTextAttributes(PyHighlighter.PY_FUNC_DEFINITION);
            }
        }
    }

    @Override
    public void visitPyDecoratorList(PyDecoratorList node) {
        PyDecorator[] decos;
        for (PyDecorator deco : decos = node.getDecorators()) {
            this.highlightDecorator(deco);
        }
    }

    private void highlightDecorator(PyDecorator node) {
        PsiElement mk = node.getFirstChild();
        if (mk != null && (mk = mk.getNextSibling()) != null) {
            Annotation ann = this.getHolder().createInfoAnnotation(mk, null);
            ann.setTextAttributes(PyHighlighter.PY_DECORATOR);
        }
    }
}

