/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.validation.PyAnnotator;
import org.jetbrains.annotations.NotNull;

public class PyBuiltinAnnotator
extends PyAnnotator {
    @Override
    public void visitPyReferenceExpression(PyReferenceExpression node) {
        String name = node.getName();
        if (name == null) {
            return;
        }
        boolean highlightedAsAttribute = this.highlightAsAttribute(node, name);
        if (!highlightedAsAttribute && PyBuiltinCache.isInBuiltins(node)) {
            PsiElement parent = node.getParent();
            Annotation ann = parent instanceof PyDecorator ? this.getHolder().createInfoAnnotation(parent.getFirstChild(), null) : this.getHolder().createInfoAnnotation((PsiElement)node, null);
            ann.setTextAttributes(PyHighlighter.PY_BUILTIN_NAME);
        }
    }

    @Override
    public void visitPyTargetExpression(PyTargetExpression node) {
        String name = node.getName();
        if (name != null) {
            this.highlightAsAttribute(node, name);
        }
    }

    private boolean highlightAsAttribute(@NotNull PyQualifiedExpression node, @NotNull String name) {
        ASTNode tgt;
        ASTNode astNode;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/python/validation/PyBuiltinAnnotator", "highlightAsAttribute"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/python/validation/PyBuiltinAnnotator", "highlightAsAttribute"));
        }
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)node);
        if ((PyNames.UnderscoredAttributes.contains((Object)name) || PyNames.getBuiltinMethods(languageLevel).containsKey((Object)name)) && (node.isQualified() || ScopeUtil.getScopeOwner((PsiElement)node) instanceof PyClass) && (astNode = node.getNode()) != null && (tgt = astNode.findChildByType((IElementType)PyTokenTypes.IDENTIFIER)) != null) {
            Annotation ann = this.getHolder().createInfoAnnotation(tgt, null);
            ann.setTextAttributes(PyHighlighter.PY_PREDEFINED_USAGE);
            return true;
        }
        return false;
    }
}

